#!/usr/bin/env python
# -*- coding: utf-8 -*-


import gimp, gimpplugin, math
from gimpenums import *
pdb = gimp.pdb
import gtk, gimpui, pnt2d
from pnt2d import *

from araknepathshapecreatorshapes import *
import gimpshelf
import os, sys, gettext
p=os.path.dirname(sys.argv[0]) + os.sep +'locales'

gettext.install("arakne-path-shape-creator", p, unicode=True)

varBez = 0.551915024494

pathcreator_key='arakne-shape-creator'

CORNERS=[[_('Rounded'),0],[_('Rounded inverse'),1],[_('Chamfer'),2]]
CORNERSROMB=[[_('Rounded'),0],[_('Chamfer'),1]]
POLYSEL=[[_('Polygon'),0],[_('Circle'),1]]
ArrowSEL=[[_('Top'),0],[_('Bottom'),1],[_('Left'),2],[_('Right'),3]]
ArcSEL=[[_('Open'),0],[_('At center'),1],[_('Linear'),2]]
# selection modes:
oppSel=[["Add to current",0],["Substract",1],["Replace current",2],["Intersect",3]]
oppFill=[["Don't fill",0],["With foreground",1],["With background",2]]
oppStro=[["Don't stroke",0],["Stroke path",1],["Stroke over fill",2]]
sIntRadius=_("Interior radius %:")

def shapeSquare(x1,x2,y1,y2, v1,v2,v3,v4,v5,v6):
	an, al=(x2 - x1, y2 - y1)
	la = min(an,al)
	incX, incY = ((an-la) / 2.0,(al-la) / 2.0)
	iX,iY =(x1+incX,y1+incY)
	name='squa'
	p1, p2, p3, p4 =(pnt2d(iX,iY), pnt2d(iX + la,iY), pnt2d(iX + la,iY + la), pnt2d(iX,iY + la))
	bezs=[bezpnt(p1),bezpnt(p2),bezpnt(p3),bezpnt(p4)]
	if v1>0:
		fpts=[None, pnt2d(iX,iY+v1), pnt2d(iX+v1,iY), pnt2d(iX+la-v1,iY), pnt2d(iX+la,iY+v1), pnt2d(iX+la,iY+la-v1), pnt2d(iX+la-v1,iY+la), pnt2d(iX+v1,iY+la), pnt2d(iX,iY+la-v1)]
		if v6 in [0,2]:
			name = name + _('chamfer') if v6==1 else name + _('rounded')
			r2=v1 if v6==2 else v1*varBez
			fpts2=[pnt2d(iX,iY+r2) ,pnt2d(iX+r2,iY), pnt2d(iX+la-r2,iY), pnt2d(iX+la,iY+r2), pnt2d(iX+la,iY+la-r2), pnt2d(iX+la-r2,iY+la), pnt2d(iX+r2,iY+la), pnt2d(iX,iY+la-r2)]
		elif v6==1:
			name += _('roundInv')
			r2 = v1 * varBez
			fpts2=[pnt2d(iX+r2,iY+v1), pnt2d(iX+v1,iY+r2) ,pnt2d(iX+la-v1,iY+r2), pnt2d(iX+la-r2,iY+v1),
				pnt2d(iX+la-r2,iY+la-v1), pnt2d(iX+la-v1,iY+la-r2), pnt2d(iX+v1,iY+la-r2), pnt2d(iX+r2,iY+la-v1)]
		if v6 in [0,1,2]:
			bezs=[
				bezpnt(fpts[1],None,fpts2[0]), bezpnt(fpts[2],fpts2[1]), bezpnt(fpts[3],None,fpts2[2]), bezpnt(fpts[4],fpts2[3]),
				bezpnt(fpts[5],None,fpts2[4]), bezpnt(fpts[6],fpts2[5]), bezpnt(fpts[7],None,fpts2[6]), bezpnt(fpts[8],fpts2[7])]
	return [name,bezs,_('Max. roundness:'),la/2,True]

SHAPES2={'squa':{'tit':_('Square'),'def':shapeSquare,'labels':[_("Roundness:"),"-","-",_("Corners:"),"-",CORNERS]}}

def centerBezs(bezs,x1,y1,an,al):
	for bez in bezs: bez.translate(x1+an/2.0, y1+al/2.0)
	return bezs

import shapes

def debug(val):
	gimp.message(str(val))

class sVecUtls(object):
	pnts=[]
	pntsbak=[]
	thispath=None
	name='cuad'
	change=True

	def __init__(self, runmode, img):
		self.img = img
		if runmode == RUN_INTERACTIVE:
			self.showDialog()
		elif runmode == RUN_WITH_LAST_VALS:
			self.showDialog()
		elif runmode == RUN_NONINTERACTIVE:
			return

	def addRows(self, obj, table, col1,col2, row1,row2,cnn="",function=None):
		table.attach(obj, col1, col2, row1, row2)
		obj.show()
		if cnn!="": obj.connect(cnn, function)
		return obj

	def addCellsInfo(self, txLab, iniCell, row, val, maxValue, name):
		self.addRows(gtk.Label(txLab), self.tabRgt, iniCell, iniCell+1, row, row+1)
		este=self.addRows(gtk.SpinButton(gtk.Adjustment(val,0, maxValue, 1), 0.0, 0), self.tabRgt, iniCell+1, iniCell+2, row, row+1)
		este.set_name(name)
		esteFn=este.connect("changed", self.chDim)
		return [este,esteFn]

	def addLabel(self,tx,alignx=1.0,aligny=0.5):
		lb=gtk.Label(tx)
		lb.set_alignment(alignx,aligny)
		return lb

	def chShape(self, widget):
		iter = widget.get_active_iter()
		model = widget.get_model()
		lP = model.get_value(iter,1)
		try:
			esteF=SHAPES2[lP]['labels']
			self.setLabels(esteF[0],esteF[1],esteF[2],esteF[3],esteF[4],esteF[5])
			self.chPath(widget)
		except Exception,e:
			debug(e)

	def showDialog(self):
		self.change=False
		if self.thispath==None:
			self.thispath = pdb.gimp_vectors_new(self.img, self.name)
			pdb.gimp_image_add_vectors(self.img, self.thispath, 0)
		self.dialog = gimpui.Dialog("Shapes creator", "rotdlg")
		self.dialog.set_position(gtk.WIN_POS_CENTER)
		self.table = gtk.Table(3, 1, False)
		self.table.set_homogeneous(False)
		self.table.set_row_spacings(1)
		self.table.set_col_spacings(1)
		self.table.show()
		row=1

		self.tabLeft = gtk.Table(6, 8, False)
		self.tabLeft.set_homogeneous(False)
		self.tabLeft.set_row_spacings(1)
		self.tabLeft.set_col_spacings(1)
		self.tabLeft.show()

		self.tabRgt = gtk.Table(6, 8, True)
		self.tabRgt.set_homogeneous(False)
		self.tabRgt.set_row_spacings(2)
		self.tabRgt.set_col_spacings(2)
		self.tabRgt.show()

		self.addRows(self.tabLeft, self.table, 0, 1, 0, 1)
		self.addRows(self.tabRgt,  self.table, 1, 2, 0, 1)

		self.addRows(self.addLabel(_('Shape:')), self.tabLeft, 0, 1, row, row+1)
		self.lnkPath=self.addRows(self.makeCombo2(SHAPES2), self.tabLeft, 1, 2, row, row+1, "changed", self.chShape)
		row += 1
		adj=gtk.Adjustment(0, 0, 1000, 0.2)
		self.label1 = self.addRows(self.addLabel(_('Roundnes:')), self.tabLeft, 0, 1, row, row+1)
		self.valFloat1=self.addRows(gtk.SpinButton(adj, 0.0, 2), self.tabLeft, 1, 2, row, row+1, "changed", self.chPath)
		row += 1
		self.label2 = self.addRows(gtk.Label(_('Width (cross and X):')), self.tabLeft, 0, 1, row, row+1)
		self.valFloat2=self.addRows(gtk.SpinButton(gtk.Adjustment(0, 12, 1000, 0.2), 0.0, 2), self.tabLeft, 1, 2, row, row+1, "changed", self.chPath)
		row += 1
		self.label4=self.addRows(gtk.Label(_('Corners:')), self.tabLeft, 0, 1, row, row+1)
		self.lnkPt = self.addRows(self.makeCombo(CORNERS), self.tabLeft, 1, 2, row, row+1, "changed", self.chPath)
		row += 1
		self.label3=self.addRows(gtk.Label(_('Vertices/Turns:')), self.tabLeft, 0, 1, row, row+1)
		self.sidesNum=self.addRows(gtk.SpinButton(gtk.Adjustment(0, 3, 100, 1), 0.0, 0), self.tabLeft, 1, 2, row, row+1, "changed", self.chPath)
		row += 1
		self.label5=self.addRows(gtk.Label(_('Star 2nd radius %:')), self.tabLeft, 0, 1, row, row+1)
		self.starRad2=self.addRows(gtk.SpinButton(gtk.Adjustment(0, 1, 100, 1), 0.0, 0), self.tabLeft, 1, 2, row, row+1, "changed", self.chPath)
		row=row+1
		self.addRows(gtk.Label(_('Rotation:')), self.tabLeft, 0, 1, row, row+1)
		self.shapeRot=self.addRows(gtk.SpinButton(gtk.Adjustment(0, -360, 360, 1), 0.0, 0), self.tabLeft, 1, 2, row, row+1)
		self.shapeRot.connect("changed", self.chPath)
		row=row+1
		self.addRows(gtk.Label(_('Stroke path:')), self.tabLeft, 0, 1, row, row+1)
		self.selStroke = self.addRows(self.makeCombo(oppStro), self.tabLeft, 1, 2, row, row+1)
		row += 1
		self.addRows(gtk.Label(_('Current brush:')), self.tabLeft, 0, 1, row, row+1)
		self.addRows(gtk.Label(pdb.gimp_context_get_brush()), self.tabLeft, 1, 2, row, row+1)
		row=row+1
		self.addRows(gtk.Label(_('Fill:')), self.tabLeft, 0, 1, row, row+1)
		self.fillFg=self.addRows(self.makeCombo(oppFill), self.tabLeft, 1, 2, row, row+1)
		row += 1
		self.useSel=self.addRows(gtk.CheckButton("Use as selection"), self.tabLeft, 0, 2, row, row+1,"toggled", self.checkSel)
		row=row+1
		self.addRows(gtk.Label(_('Operation:')), self.tabLeft, 0, 1, row, row+1)
		self.selOpp = self.addRows(self.makeCombo(oppSel), self.tabLeft, 1, 2, row, row+1)
		self.selOpp.set_sensitive(False)
		row += 1
		self.btnadd=self.addRows(gtk.Button(_("Add shape")), self.tabLeft, 0, 2, row, row+1,"clicked", self.addbtn)
		row=row+1

		row = 0
		self.addRows(gtk.Label(_('Selection details:')), self.tabRgt, 6, 11, row, row+1)
		row=row+1
		non_empty, x1, y1, x2, y2 = pdb.gimp_selection_bounds(self.img)
		if non_empty==False: x1,y1,x2,y2=(0,0,self.img.width,self.img.height)
		self.iW,self.iWFn=self.addCellsInfo(_('Width:'),6, row, x2-x1, self.img.width, 'iW')
		self.iH,self.iHFn=self.addCellsInfo(_('Height:'),8, row, y2-y1, self.img.height, 'iH')
		row=row+1
		self.iL,self.iLFn=self.addCellsInfo(_('Left:'),6, row, x1, self.img.width, 'iL')
		self.iR,self.iRFn=self.addCellsInfo(_('Right:'),8, row, x2, self.img.width, 'iR')
		row=row+1
		self.iT,self.iTFn=self.addCellsInfo(_('Top:'),6, row, y1, self.img.height, 'iT')
		self.iB,self.iBFn=self.addCellsInfo(_('Bottom:'),8, row, y2, self.img.height, 'iB')
		row=row+1
		self.addRows(gtk.Label(_('Shrink/Grow:')), self.tabRgt, 6, 9, row, row+1)
		self.shrinkGrow=self.addRows(gtk.SpinButton(gtk.Adjustment(0, -200, 200, 1), 0.0, 0), self.tabRgt, 9, 10, row, row+1, "changed", self.chPath)
		row += 1
		self.infoETit=gtk.Label(_('Info extra:'))
		self.addRows(self.infoETit, self.tabRgt, 6, 8, row, row+1)
		self.infoE=gtk.Label('?')
		self.addRows(self.infoE, self.tabRgt, 8, 10, row, row+1)
		row=row+1

		self.dialog.vbox.hbox1 = gtk.HBox(False, 7)
		self.dialog.vbox.hbox1.show()
		self.dialog.vbox.pack_start(self.dialog.vbox.hbox1, True, True, 7)
		self.dialog.vbox.hbox1.pack_start(self.table, True, True, 7)
		ok_button = self.dialog.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)
		cancel_button = self.dialog.add_button(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)
		cancel_button.connect("clicked", self.kobtn)
		ok_button.connect("clicked", self.okbtn)
		
		flds=SHAPES2[SHAPES2.keys()[0]]
		labs=flds['labels']
		self.setLabels(labs[0],labs[1],labs[2],labs[3],labs[4],labs[5])

		self.dialog.show()
		self.chShape(self.lnkPath)
		self.dialog.run()

	def checkSel(self, widget, data=None):
		self.selOpp.set_sensitive(widget.get_active())

	def chDim(self, widget):
		este = widget.get_name()
		iLv=self.iL.get_value_as_int()
		iRv=self.iR.get_value_as_int()
		iWv=self.iW.get_value_as_int()
		iHv=self.iH.get_value_as_int()
		iTv=self.iT.get_value_as_int()
		iBv=self.iB.get_value_as_int()
		self.change=False
		if este=='iW':
			self.iR.disconnect(self.iRFn)
			self.iR.set_value(iWv + iLv)
			self.iRFn=self.iR.connect("changed", self.chDim)
		if este=='iH':
			self.iB.disconnect(self.iBFn)
			self.iB.set_value(iHv + iTv)
			self.iBFn=self.iB.connect("changed", self.chDim)
		if este=='iR' or este=='iL':
			self.iW.disconnect(self.iWFn)
			self.iW.set_value(iRv - iLv)
			self.iWFn=self.iW.connect("changed", self.chDim)
		if este=='iT' or este=='iB':
			self.iH.disconnect(self.iHFn)
			self.iH.set_value(iBv - iTv)
			self.iHFn=self.iH.connect("changed", self.chDim)
		self.change=True
		self.chPath(widget)

	def chPath(self, widget):
		if self.change==False: return
		iter = self.lnkPath.get_active_iter()
		model = self.lnkPath.get_model()
		lP = model.get_value(iter,1)
		corners=self.lnkPt.get_active()
		vF1=self.valFloat1.get_value()
		sides=self.sidesNum.get_value()
		starrad2=self.starRad2.get_value()
		non_empty, x1, y1, x2, y2 = pdb.gimp_selection_bounds(self.img)
		if non_empty==False: x1,y1,x2,y2=(0,0,self.img.width,self.img.height)
		x1, x2, y1, y2 = (self.iL.get_value(), self.iR.get_value(), self.iT.get_value(), self.iB.get_value())
		sg=self.shrinkGrow.get_value()
		if sg<>0:
			x1-=sg
			x2+=sg
			y1-=sg
			y2+=sg
		bezs=[]
		pnts=[]
		shp=SHAPES2[lP]
		Def=shp['def']
		try:
			name,bezs,xtraTit,xtraVal,closed=Def(x1,x2,y1,y2, vF1,self.valFloat2.get_value(),sides,0,starrad2,corners)
			self.extraInfo(xtraTit,xtraVal)
		except Exception,e:
			debug(e)
		gp = gimppath(bezs)
		rotShape=self.shapeRot.get_value()
		if rotShape<>0: gp.rotdeg(rotShape,x1+an/2.0,y1+al/2.0)
		gp.compact()
		pnts = gp.toGimpPath()
		self.pnts = pnts
		self.name = name
		if self.pntsbak<>self.pnts:
			defvals={}
			if gimpshelf.shelf.has_key(pathcreator_key):
				defvals=gimpshelf.shelf[pathcreator_key]
			defvals[lP]=[vF1, self.valFloat2.get_value(), sides, corners, starrad2]
			gimpshelf.shelf[pathcreator_key] = defvals
			if len(self.thispath.strokes)>0:
				pdb.gimp_vectors_remove_stroke(self.thispath, self.thispath.strokes[0].ID)
			pdb.gimp_vectors_stroke_new_from_points(self.thispath, 0, len(self.pnts), self.pnts, closed)
			self.thispath.name=name
			pdb.gimp_item_set_visible(self.thispath, True)
			self.pntsbak=self.pnts

	def labelsShowhide(self, lb,tx,fld):
		lb.set_text(tx)
		if tx=='-':
			lb.hide()
			fld.hide()
		else:
			lb.show()
			fld.show()

	def setLabels(self,tx1,tx2,tx3,tx4,tx5,tx6=""):
		defvals={}
		self.change=False
		if gimpshelf.shelf.has_key(pathcreator_key):
			iter = self.lnkPath.get_active_iter()
			model = self.lnkPath.get_model()
			lP = model.get_value(iter,1)
			defvals=gimpshelf.shelf[pathcreator_key]
			if lP in defvals:
				vals=defvals[lP]
				self.valFloat1.set_value(vals[0])
				self.valFloat2.set_value(vals[1])
				self.sidesNum.set_value(vals[2])
				self.starRad2.set_value(vals[4])
				self.chPath(self)
		self.labelsShowhide(self.label1, tx1, self.valFloat1)
		self.labelsShowhide(self.label2, tx2, self.valFloat2)
		self.labelsShowhide(self.label3, tx3, self.sidesNum)
		if tx6<>"-": self.fillCombo(tx6,self.lnkPt)
		self.labelsShowhide(self.label4, tx4, self.lnkPt)
		self.labelsShowhide(self.label5, tx5, self.starRad2)
		self.change=True

	def extraInfo(self,tit1,maxFloat,field=None):
		self.infoETit.set_text(tit1)
		self.infoE.set_text('%.2f'%(maxFloat))

	def fillCombo(self, Store, combobox):
		st = combobox.get_model()
		st.clear()
		for n in Store: st.append(n)
		combobox.set_model(st)
		combobox.set_active(0)

	def makeCombo(self, Store):
		st = gtk.ListStore(str, int)
		self.cmb = gtk.ComboBox(st)
		cell = gtk.CellRendererText()
		self.fillCombo(Store,self.cmb)
		self.cmb.pack_start(cell, True)
		self.cmb.add_attribute(cell, 'text', 0)
		self.cmb.set_active(0)
		return self.cmb

	def fillCombo2(self, Store, combobox):
		st = combobox.get_model()
		st.clear()
		for n in Store: 
			st.append([Store[n]['tit'],n])
		combobox.set_model(st)
		combobox.set_active(0)

	def makeCombo2(self, Store):
		st = gtk.ListStore(str, str)
		self.cmb = gtk.ComboBox(st)
		cell = gtk.CellRendererText()
		self.fillCombo2(Store,self.cmb)
		self.cmb.pack_start(cell, True)
		self.cmb.add_attribute(cell, 'text', 0)
		self.cmb.set_active(0)
		return self.cmb

	def bakSelection(self):
		selection = pdb.gimp_image_get_selection(self.img)
		channel = pdb.gimp_selection_save(self.img)
		pdb.gimp_image_select_item(self.img, 2, channel)
		
	def selAndFill(self,widget):
		drawable = pdb.gimp_image_get_active_drawable(self.img)
		flush=False
		stroke=self.selStroke.get_active()
		fill=self.fillFg.get_active()
		if stroke>0 or fill>0:
			channel = pdb.gimp_selection_save(self.img)
			pdb.gimp_selection_all(self.img)
			if stroke==1:
				pdb.gimp_edit_stroke_vectors(drawable, self.thispath)
			if fill>0:
				pdb.gimp_image_select_item(self.img, 2, self.thispath)
				pdb.gimp_edit_fill(drawable, fill-1)
			if stroke==2:
				pdb.gimp_selection_none(self.img)
				pdb.gimp_edit_stroke_vectors(drawable, self.thispath)
			pdb.gimp_image_select_item(self.img, 2, channel)
			if pdb.gimp_item_is_layer(drawable): pdb.gimp_image_set_active_layer(self.img, drawable)
			pdb.gimp_image_remove_channel(self.img, channel)
			drawable.flush()
		if self.useSel.get_active()==True: pdb.gimp_image_select_item(self.img, self.selOpp.get_active(), self.thispath)
		gimp.displays_flush()

	def okbtn(self, widget):
		self.selAndFill(widget)
		self.thispath = None

	def addbtn(self, widget):
		self.selAndFill(None)
		self.thispath = pdb.gimp_vectors_new(self.img, self.name)
		pdb.gimp_image_add_vectors(self.img, self.thispath, 0)
		self.change=True
		self.pntsbak=[]
		self.chPath(widget)
		return False

	def kobtn(self, widget):
		pdb.gimp_image_remove_vectors(self.img, self.thispath)

class pyWSutils(gimpplugin.plugin):
	def start(self):
		gimp.main(self.init, self.quit, self.query, self._run)
	def init(self):
		pass
	def quit(self):
		pass
	def query(self):
		author = "jfgarcia"
		cright = "jfgarcia"
		date = "2013-2014"
		plug_descr = _("Create paths centered on the current selection")
		plug_params = [(PDB_INT32, "run_mode", "Run mode"), (PDB_IMAGE, "image", "Input image"),]
		gimp.install_procedure("path_shape_creator5", plug_descr, plug_descr, author, cright, date, _("<Image>/Filters/Path/path shape creator..."), "RGB*, GRAY*", PLUGIN, plug_params,[])

	def path_shape_creator5(self, runmode, img):
		sVecUtls(runmode, img)

if __name__ == '__main__':
	pyWSutils().start()
# 587, 442