#!/usr/bin/env python
# -*- coding: utf-8 -*-

# v6a
#    Solved error with rotation
#    Unified defs ShapeRect and ShapeQuad, the external shape ShapeRect deleted
# v6b
#    solved error with rectangles
#    added minimal value for shape options
#    sorted list of shapes
#    new shapes: star sllipse, polygon ellipse
# v6c
#    No more Square and Circle shapes, check the option Squared selection from Selection tab
#    for get square and circle of rectangle and ellipse

import gimp, gimpplugin, math
from gimpenums import *
pdb = gimp.pdb
import gtk, gimpui, pnt2d, drawUI

useCollections=True
try:
	__import__('collections')
except ImportError:
	useCollections=False
else:
	import collections

from pnt2d import *

from araknepathshapecreatorshapes import *
import gimpshelf, os, sys, gettext
p=os.path.dirname(sys.argv[0]) + os.sep +'locales'

gettext.install("arakne-path-shape-creator", p, unicode=True)

varBez = 0.551915024494

pathcreator_key='arakne-shape-creator'

CORNERS=[[_('Rounded'),0],[_('Rounded inverse'),1],[_('Chamfer'),2]]
CORNERSROMB=[[_('Rounded'),0],[_('Chamfer'),1]]
POLYSEL=[[_('Polygon'),0],[_('Circle'),1]]
ArrowSEL=[[_('Top'),0],[_('Bottom'),1],[_('Left'),2],[_('Right'),3]]
ArcSEL=[[_('Open'),0],[_('At center'),1],[_('Linear'),2]]
# selection modes:
oppSel=[["Add to current",0],["Substract",1],["Replace current",2],["Intersect",3]]
oppFill=[["Don't fill",0],["With foreground",1],["With background",2],["With pattern",3]]

oppStro=[["Don't stroke",0],["Stroke path",1],["Stroke over fill",2]]
sIntRadius=_("Interior radius %:")

def shapeRectangle(x1,x2,y1,y2, v1,v2,v3,v4,v5,v6):
	name=_('rect')
	bezs=[bezpnt([x1,y1]), bezpnt([x1,y2]), bezpnt([x2,y2]), bezpnt([x2,y1])]
	an, al=(x2 - x1, y2 - y1)
	rad=v1
	if rad>0:
		corners = v6
		if corners==1:
			name+=_('RoundedInv')
			r2=rad*varBez
			fpts2=[[x1+r2,y1+rad], [x1+rad,y1+r2], [x2-rad,y1+r2], [x2-r2,y1+rad], [x2-r2,y2-rad], [x2-rad,y2-r2], [x1+rad,y2-r2], [x1+r2,y2-rad]]
		elif corners in [0,2]:
			name=name+_('chamfer') if corners==2 else name+_('rounded')
			r2=rad if corners==2 else rad*varBez
			fpts2=[[x1,y1+r2], [x1+r2,y1], [x2-r2,y1], [x2,y1+r2], [x2,y2-r2], [x2-r2,y2], [x1+r2,y2], [x1,y2-r2]]
		bezs=[
			bezpnt([x1,y1+rad],None,fpts2[0]), bezpnt([x1+rad,y1],fpts2[1]),
			bezpnt([x2-rad,y1],None,fpts2[2]), bezpnt([x2,y1+rad],fpts2[3]),
			bezpnt([x2,y2-rad],None,fpts2[4]), bezpnt([x2-rad,y2],fpts2[5]),
			bezpnt([x1+rad,y2],None,fpts2[6]), bezpnt([x1,y2-rad],fpts2[7])
		]
	return [name,bezs,'Max. roundness:',min(al,an)/2.0,True]

if useCollections:
	SHAPES2={'rect':{'tit':_('Rectangle'),'def':shapeRectangle,'labels':[_("Roundness:"),"-","-",_("Corners:"),"-",CORNERS]}}

def centerBezs(bezs,x1,y1,an,al):
	for bez in bezs: bez.translate(x1+an/2.0, y1+al/2.0)
	return bezs

def debug(val):
	gimp.message(str(val))

def debugErr(e):
	exc_type, exc_obj, exc_tb = sys.exc_info()
	fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
	debug(fname+'\n'+str(exc_tb.tb_lineno)+'\n'+str(e))

import shapes

try:
	SHAPES2=collections.OrderedDict(sorted(SHAPES2.items(), key=lambda t: t[1]['tit']))
except Exception,e:
	debug('Your distribution don''t suport collections.OrderedDict')

class sVecUtls(object):
	pnts=[]
	pntsbak=[]
	thispath=None
	name='cuad'
	change=True
	selBak=[]
	tabs=[]
	ui=drawUI.drawUi()

	tabTits=[_('Shape'),_('Selection'),_('Fill and border'),_('Transforms')]
	def __init__(self, runmode, img):
		self.img = img
		if runmode == RUN_INTERACTIVE:
			self.showDialog()
		elif runmode == RUN_WITH_LAST_VALS:
			self.showDialog()
		elif runmode == RUN_NONINTERACTIVE:
			return

	def addCellsInfo(self, txLab, iniCell, row, val, maxValue, name):
		self.ui.addRows(self.ui.addLabel(txLab), self.tabs[1], iniCell, iniCell+1, row, row+1)
		este=self.ui.addRows(gtk.SpinButton(gtk.Adjustment(val,0, maxValue, 1), 0.0, 0), self.tabs[1], iniCell+1, iniCell+2, row, row+1)
		este.set_name(name)
		este.connect("activate",self.evalSpin,'activate')
		esteFn=este.connect("changed", self.chDim)
		return [este,esteFn]

	def chShape(self, widget):
		lP = self.ui.getModelVal(widget)
		esteF=SHAPES2[lP]['labels']
		self.setLabels(esteF[0],esteF[1],esteF[2],esteF[3],esteF[4],esteF[5])
		try:
			self.chPath(widget)
		except Exception,e:
			debugErr('from chShape: '+str(e))

	def tabTransform(self, tab):
		row = 0
		self.ui.addRows(self.ui.addLabel(_('Rotation:')), tab, 0, 2, row, row+1)
		self.shapeRot=self.ui.addRows(gtk.SpinButton(gtk.Adjustment(0, -360, 360, 1), 0.0, 0), tab, 2, 4, row, row+1, "changed", self.chPath)
		row+=1
		self.ui.addRows(self.ui.addLabel(_('Skew X:')), tab, 0, 2, row, row+1)
		self.skewX=self.ui.addRows(gtk.SpinButton(gtk.Adjustment(0, -360, 360, 1), 0.0, 0), tab, 2, 4, row, row+1, "changed", self.chPath)
		row+=1
		self.ui.addRows(self.ui.addLabel(_('Skew Y:')), tab, 0, 2, row, row+1)
		self.skewY=self.ui.addRows(gtk.SpinButton(gtk.Adjustment(0, -360, 360, 1), 0.0, 0), tab, 2, 4, row, row+1, "changed", self.chPath)
		row += 1
		self.mirrorX=self.ui.addRows(gtk.CheckButton(_("Mirror X")), tab, 2, 4, row, row+1, "toggled", self.chPath)
		row+=1
		self.mirrorY=self.ui.addRows(gtk.CheckButton(_("Mirror Y")), tab, 2, 4, row, row+1, "toggled", self.chPath)

	def tabSelection(self, tab):
		row = 0
		self.ui.addRows(self.ui.addLabel(_('Selection details:'),0), tab, 6, 11, row, row+1)
		row=row+1
		non_empty, x1, y1, x2, y2 = pdb.gimp_selection_bounds(self.img)
		if non_empty==False: x1,y1,x2,y2=(0,0,self.img.width,self.img.height)
		self.iW,self.iWFn=self.addCellsInfo(_('Width:'),6, row, x2-x1, self.img.width, 'iW')
		self.iH,self.iHFn=self.addCellsInfo(_('Height:'),8, row, y2-y1, self.img.height, 'iH')
		row=row+1
		self.iL,self.iLFn=self.addCellsInfo(_('Left:'),6, row, x1, self.img.width, 'iL')
		self.iR,self.iRFn=self.addCellsInfo(_('Right:'),8, row, x2, self.img.width, 'iR')
		row+=1
		self.iT,self.iTFn=self.addCellsInfo(_('Top:'),6, row, y1, self.img.height, 'iT')
		self.iB,self.iBFn=self.addCellsInfo(_('Bottom:'),8, row, y2, self.img.height, 'iB')
		row+=1
		self.ui.addRows(self.ui.addLabel(_('Shrink/Grow:')), tab, 6, 9, row, row+1)
		self.shrinkGrow=self.ui.addRows(gtk.SpinButton(gtk.Adjustment(0, -200, 200, 1), 0.0, 0), tab, 9, 10, row, row+1, "changed", self.chPath)
		#try:
		#	self.selFont=self.ui.addRows(gimpui.FontSelector("Sans"), tab, 9, 10, row, row+1)
		#except Exception,e:
		#	debug(e)
		
		row += 1
		self.squaSel = self.ui.addRows(gtk.CheckButton("Square selection"), tab, 0, 10, row, row+1,"toggled", self.chPath)

	def showDialog(self):
		self.change=False
		if self.thispath==None:
			self.thispath = pdb.gimp_vectors_new(self.img, self.name)
			pdb.gimp_image_add_vectors(self.img, self.thispath, 0)
		self.dialog = gimpui.Dialog("Shapes creator", "rotdlg")
		self.dialog.set_keep_above(True)
		self.dialog.set_position(gtk.WIN_POS_CENTER)
		self.table = gtk.Table(3, 1, False)
		self.table.set_homogeneous(False)
		self.table.set_row_spacings(1)
		self.table.set_col_spacings(1)
		self.table.show()
		self.btnSel=self.ui.addRows(gtk.Button(_("Update selection")), self.table, 0, 2, 2, 3,"clicked", self.updselbtn)
		self.btnadd=self.ui.addRows(gtk.Button(_("Add shape")), self.table, 0, 2, 3, 4,"clicked", self.addbtn)
		self.nB = gtk.Notebook()

		self.ui.addRows(self.nB, self.table, 0, 1, 0, 1)

		for n in range(0,len(self.tabTits)):
			t = gtk.Table(6, 2, False)
			t.set_homogeneous(False)
			t.set_row_spacings(2)
			t.set_col_spacings(2)
			t.show()
			self.tabs.append(t)
			self.nB.append_page(self.tabs[n], gtk.Label(self.tabTits[n]))
		row=0
		self.ui.addRows(self.ui.addLabel(_('Shape:')), self.tabs[0], 0, 1, row, row+1)
		self.lnkPath=self.ui.addRows(self.ui.makeCombo2(SHAPES2), self.tabs[0], 1, 2, row, row+1)
		row += 1
		adj=gtk.Adjustment(0, 0, 1000, 0.2)
		self.lb1 = self.ui.addRows(self.ui.addLabel(_('Roundnes:')), self.tabs[0], 0, 1, row, row+1)
		self.vFlt1=self.ui.addRows(gtk.SpinButton(adj, 0.0, 2), self.tabs[0], 1, 2, row, row+1, "changed", self.chPath)
		row += 1
		self.lb2 = self.ui.addRows(self.ui.addLabel(_('Width (cross and X):')), self.tabs[0], 0, 1, row, row+1)
		self.vFlt2=self.ui.addRows(gtk.SpinButton(gtk.Adjustment(0, 0, 1000, 0.2), 0.0, 2), self.tabs[0], 1, 2, row, row+1, "changed", self.chPath)
		row += 1
		self.lb4=self.ui.addRows(self.ui.addLabel(_('Corners:')), self.tabs[0], 0, 1, row, row+1)
		self.lnkPt = self.ui.addRows(self.ui.makeCombo(CORNERS), self.tabs[0], 1, 2, row, row+1, "changed", self.chPath)
		row += 1
		self.lb3=self.ui.addRows(self.ui.addLabel(_('Vertices/Turns:')), self.tabs[0], 0, 1, row, row+1)
		self.vFlt3=self.ui.addRows(gtk.SpinButton(gtk.Adjustment(0, 0, 100, 1), 0.0, 0), self.tabs[0], 1, 2, row, row+1, "changed", self.chPath)
		row += 1
		self.lb5=self.ui.addRows(self.ui.addLabel(_('Star 2nd radius %:')), self.tabs[0], 0, 1, row, row+1)
		self.vFlt5=self.ui.addRows(gtk.SpinButton(gtk.Adjustment(0, 0, 100, 1), 0.0, 0), self.tabs[0], 1, 2, row, row+1, "changed", self.chPath)
		row+=1
		self.infoETit=gtk.Label(_('Info extra:'))
		self.ui.addRows(self.infoETit, self.tabs[0], 0, 1, row, row+1)
		self.infoE=gtk.Label('?')
		self.ui.addRows(self.infoE, self.tabs[0], 1, 2, row, row+1)

		# ######################## tabFill
		row=0
		self.ui.addRows(gtk.Label(_('Stroke path:')), self.tabs[2], 0, 1, row, row+1)
		self.selStroke = self.ui.addRows(self.ui.makeCombo(oppStro), self.tabs[2], 1, 2, row, row+1)
		row += 1
		self.ui.addRows(gtk.Label(_('Current brush:')), self.tabs[2], 0, 1, row, row+1)
		angle = pdb.gimp_context_get_brush_angle()
		aspect = pdb.gimp_context_get_brush_aspect_ratio()
		size = pdb.gimp_context_get_brush_size()
		descBr=pdb.gimp_context_get_brush()+'\n'+_("Angle: ")+str(angle)+'\n'+_("Aspect: ")+str(aspect)+'\n'+_("Size: ")+str(size)

		self.ui.addRows(gtk.Label(descBr), self.tabs[2], 1, 2, row, row+1)
		row=row+1
		self.ui.addRows(gtk.Label(_('Fill:')), self.tabs[2], 0, 1, row, row+1)
		self.fillFg=self.ui.addRows(self.ui.makeCombo(oppFill), self.tabs[2], 1, 2, row, row+1)
		row += 1
		self.newLayer=self.ui.addRows(gtk.CheckButton(_("Add new layer for fill-stroke")), self.tabs[2], 0, 2, row, row+1)
		row=row+1
		self.useSel=self.ui.addRows(gtk.CheckButton(_("Use as selection")), self.tabs[2], 0, 2, row, row+1,"toggled", self.checkSel)
		row=row+1
		self.ui.addRows(gtk.Label(_('Operation:')), self.tabs[2], 0, 1, row, row+1)
		self.selOpp = self.ui.addRows(self.ui.makeCombo(oppSel), self.tabs[2], 1, 2, row, row+1)
		self.selOpp.set_sensitive(False)
		row += 1

		self.tabSelection(self.tabs[1])
		self.tabTransform(self.tabs[3])

		for wg in [self.vFlt1,self.vFlt2,self.vFlt3,self.shapeRot,self.shrinkGrow,self.vFlt5,self.skewX,self.skewY]:
			wg.connect("activate",self.evalSpin,'activate')
		self.dialog.vbox.hbox1 = gtk.HBox(False, 7)
		self.dialog.vbox.hbox1.show()
		self.dialog.vbox.pack_start(self.dialog.vbox.hbox1, True, True, 3)
		self.dialog.vbox.hbox1.pack_start(self.table, True, True, 3)
		cancel_button = self.dialog.add_button(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)
		cancel_button.connect("clicked", self.kobtn)
		
		flds=SHAPES2[SHAPES2.keys()[0]]
		labs=flds['labels']
		
		if gimpshelf.shelf.has_key(pathcreator_key):
			lastshape=gimpshelf.shelf[pathcreator_key]['lastshape']
			model = self.lnkPath.get_model()
			pos=0
			for n in model:
				if n[1]==lastshape: self.lnkPath.set_active(pos)
				pos+=1
		self.setLabels(labs[0],labs[1],labs[2],labs[3],labs[4],labs[5])
		self.lnkPath.connect("changed", self.chShape)
		self.dialog.show()
		self.chShape(self.lnkPath)
		self.dialog.run()

	def checkSel(self, widget, data=None):
		self.selOpp.set_sensitive(widget.get_active())

	def evalSpin(self, widget, data=None):
		s=widget.get_text()
		s=s.replace('W',str(self.img.width))
		s=s.replace('H',str(self.img.height))
		widget.set_value(eval(s))

	def chSizeVal(self, obj, objSignal, value):
		# disable the on change function, change the value and enable the function again
		obj.disconnect(objSignal)
		obj.set_value(value)
		objSignal = obj.connect("changed", self.chDim)
		return objSignal

	def chDim(self, widget):
		este = widget.get_name()
		iLv,iRv,iWv,iHv,iTv,iBv=self.ui.getValues([self.iL,self.iR,self.iW,self.iH,self.iT,self.iB])
		self.change=False
		if este=='iW':
			self.iRFn=self.chSizeVal(self.iR,self.iRFn,iWv + iLv)
		if este=='iH':
			self.iBFn=self.chSizeVal(self.iB,self.iBFn,iHv + iTv)
		if este=='iR' or este=='iL':
			self.iWFn=self.chSizeVal(self.iW,self.iWFn,iRv + iLv)
		if este=='iT' or este=='iB':
			self.iHFn=self.chSizeVal(self.iH,self.iHFn,iBv + iTv)
		self.change=True
		self.chPath(widget)

	def transformGimpPath(self,gp,x1,x2,y1,y2):
		rotShape, skX, skY=self.ui.getValues([self.shapeRot,self.skewX,self.skewY])
		mirrorX=self.mirrorX.get_active()
		mirrorY=self.mirrorY.get_active()
		cx,cy=(x1+(x2-x1)/2.0,y1+(y2-y1)/2.0)
		if rotShape!=0.0: gp.rotdeg(rotShape,cx,cy)
		if (skX+skY)>0: gp.skew(skX,skY,cx,cy)
		sx,sy=(-1 if mirrorX else 1,-1 if mirrorY else 1)
		if mirrorX or mirrorY:
			gp.translate(-cx if mirrorX else 0,-cy if mirrorY else 0)
			gp.scale(sx,sy)
			gp.translate(cx if mirrorX else 0,cy if mirrorY else 0)

	def chPath(self, widget):
		if self.change==False: return
		lP=self.ui.getModelVal(self.lnkPath)
		corners=self.lnkPt.get_active()
		vF1,vF2,vF3,vF5=self.ui.getValues([self.vFlt1,self.vFlt2,self.vFlt3,self.vFlt5])
		non_empty, x1, y1, x2, y2 = pdb.gimp_selection_bounds(self.img)
		if non_empty==False: x1,y1,x2,y2=(0,0,self.img.width,self.img.height)
		x1, x2, y1, y2, sg = self.ui.getValues([self.iL,self.iR,self.iT,self.iB,self.shrinkGrow])
		if sg<>0:
			x1-=sg
			x2+=sg
			y1-=sg
			y2+=sg
		if self.squaSel.get_active()==True:
			an, al=(x2-x1, y2-y1)
			lado=min(an,al)
			if lado!=an:
				x1=x1+(an-lado)/2.0
				x2=x2-(an-lado)/2.0
			if lado!=al:
				y1=y1+(al-lado)/2.0
				y2=y2-(al-lado)/2.0
		bezs=[]
		pnts=[]
		shp=SHAPES2[lP]
		Def=shp['def']
		try:
			name,bezs,xtraTit,xtraVal,closed=Def(x1,x2,y1,y2, vF1,vF2,vF3,0,vF5,corners)
			self.extraInfo(xtraTit,xtraVal)
		except Exception,e:
			debugErr(str(e))
		if type(bezs[0])==list:
			v = pdb.gimp_vectors_new(self.img, 'pppp')
			for n in bezs:
				gp = gimppath(n)
				self.transformGimpPath(gp,x1,x2,y1,y2)
				gp.compact()
		else:
			gp = gimppath(bezs)
			gp.compact()
			self.transformGimpPath(gp,x1,x2,y1,y2)
		pnts = gp.toGimpPath()
		self.pnts = pnts
		self.name = name
		if self.pntsbak<>self.pnts:
			if len(self.thispath.strokes)==1:
				pdb.gimp_vectors_remove_stroke(self.thispath, self.thispath.strokes[0].ID)
			else:
				vv=pdb.gimp_vectors_new(self.img, 'pppp')
				pdb.gimp_image_remove_vectors(self.img, self.thispath)
				pdb.gimp_image_add_vectors(self.img, vv, 0)
				self.thispath=vv
			if type(bezs[0])==list:
				for n in bezs:
					gp = gimppath(n)
					pnts = gp.toGimpPath()
					pdb.gimp_vectors_stroke_new_from_points(v, 0,  len(pnts), pnts, closed)
				pdb.gimp_image_remove_vectors(self.img, self.thispath)
				pdb.gimp_image_add_vectors(self.img, v, 0)
				self.thispath=v
			else:
				try:
					if len(self.thispath.strokes)>0: pdb.gimp_vectors_remove_stroke(self.thispath, self.thispath.strokes[0].ID)
				except Exception,e:
					debugErr(str(e))
				pdb.gimp_vectors_stroke_new_from_points(self.thispath, 0, len(self.pnts), self.pnts, closed)
			self.thispath.name=name
			pdb.gimp_item_set_visible(self.thispath, True)
			self.pntsbak=self.pnts

	def labelsShowhide(self, lb,tx,fld):
		lb.set_text(tx)
		if tx=='-':
			lb.hide()
			fld.hide()
		else:
			lb.show()
			fld.show()

	def labelDefVal(self,lb,tx,fld,value):
		Tx, digits, lower, def_val=(tx, 1, 0.0, value)
		upper=max(self.img.width,self.img.height)
		if isinstance(tx,list):
			Tx=tx[0]
			lower=tx[1]
			digits=0 if isinstance(tx[1],int) else 1
			if len(tx)>2: upper=tx[2]
			if len(tx)>3 and value==None:
				def_val=tx[3]
		def_val=0.0 if def_val==None else def_val
		fld.set_range(lower,upper)
		fld.set_digits(digits)
		fld.set_value(def_val)
		self.labelsShowhide(lb,Tx,fld)

	def setLabels(self,tx1,tx2,tx3,tx4,tx5,tx6=""):
		defvals={}
		self.change=False
		v1,v2,v3,v5=(None, None, None, None)
		ch_path=False
		if gimpshelf.shelf.has_key(pathcreator_key):
			defvals=gimpshelf.shelf[pathcreator_key]
			lP=self.ui.getModelVal(self.lnkPath)
			if lP in defvals:
				vals=defvals[lP]
				v1,v2,v3,v5=(vals[0], vals[1], vals[2], vals[4])
				ch_path=True
		if tx6<>"-": self.ui.fillCombo(tx6,self.lnkPt)
		self.labelsShowhide(self.lb4, tx4, self.lnkPt)
		self.labelDefVal(self.lb1, tx1, self.vFlt1,v1)
		self.labelDefVal(self.lb2, tx2, self.vFlt2,v2)
		self.labelDefVal(self.lb3, tx3, self.vFlt3,v3)
		self.labelDefVal(self.lb5, tx5, self.vFlt5,v5)
		if (ch_path): self.chPath(self)
		self.change=True

	def extraInfo(self,tit1,maxFloat,field=None):
		self.infoETit.set_text(tit1)
		if isinstance(maxFloat, str):
			self.infoE.set_text(maxFloat)
		else:
			self.infoE.set_text('%.2f'%(maxFloat))

	def bakSelection(self):
		selection = pdb.gimp_image_get_selection(self.img)
		channel = pdb.gimp_selection_save(self.img)
		pdb.gimp_image_select_item(self.img, 2, channel)

	def selAndFill(self,widget):
		drawable = pdb.gimp_image_get_active_drawable(self.img)
		flush=False
		stroke=self.selStroke.get_active()
		fill=self.fillFg.get_active()
		if stroke>0 or fill>0:
			if self.newLayer.get_active()==True:
				layer = pdb.gimp_layer_new(self.img, self.img.width, self.img.height, 1, 'layer_' + self.name, 100, 0)
				pdb.gimp_image_insert_layer(self.img, layer, None, 0)
				drawable=layer
			channel = pdb.gimp_selection_save(self.img)
			pdb.gimp_selection_all(self.img)
			if stroke==1:
				pdb.gimp_edit_stroke_vectors(drawable, self.thispath)
			if fill>0:
				pdb.gimp_image_select_item(self.img, 2, self.thispath)
				if fill==3: fill=5
				pdb.gimp_edit_fill(drawable, fill-1)
			if stroke==2:
				pdb.gimp_selection_none(self.img)
				pdb.gimp_edit_stroke_vectors(drawable, self.thispath)
			pdb.gimp_image_select_item(self.img, 2, channel)
			if pdb.gimp_item_is_layer(drawable): pdb.gimp_image_set_active_layer(self.img, drawable)
			pdb.gimp_image_remove_channel(self.img, channel)
			drawable.flush()
		if self.useSel.get_active()==True: pdb.gimp_image_select_item(self.img, self.selOpp.get_active(), self.thispath)
		gimp.displays_flush()

	def saveToShelf(self):
		lP = self.ui.getModelVal(self.lnkPath)
		corners=self.lnkPt.get_active()
		vF1, vF2, vF3, vF5=self.ui.getValues([self.vFlt1,self.vFlt2, self.vFlt3, self.vFlt5])
		defvals={}
		if gimpshelf.shelf.has_key(pathcreator_key): defvals=gimpshelf.shelf[pathcreator_key]
		defvals['lastshape']=lP
		defvals[lP]=[vF1, vF2, vF3, corners, vF5]
		gimpshelf.shelf[pathcreator_key] = defvals

	def addbtn(self, widget):
		self.saveToShelf()
		self.selAndFill(None)
		self.thispath = pdb.gimp_vectors_new(self.img, self.name)
		pdb.gimp_image_add_vectors(self.img, self.thispath, 0)
		self.change=True
		self.pntsbak=[]
		self.chPath(widget)
		return False

	def updselbtn(self, widget):
		non_empty, x1, y1, x2, y2 = pdb.gimp_selection_bounds(self.img)
		if non_empty==False: x1,y1,x2,y2=(0,0,self.img.width,self.img.height)
		self.change=False
		self.iWFn=self.chSizeVal(self.iW, self.iWFn, x2-x1)
		self.iHFn=self.chSizeVal(self.iH, self.iHFn, y2-y1)
		self.iLFn=self.chSizeVal(self.iL, self.iLFn, x1)
		self.iRFn=self.chSizeVal(self.iR, self.iRFn, x2)
		self.iTFn=self.chSizeVal(self.iT, self.iTFn, y1)
		self.iBFn=self.chSizeVal(self.iB, self.iBFn, y2)
		self.change=True
		self.chPath(widget)
		return False

	def kobtn(self, widget):
		if pdb.gimp_item_is_valid(self.thispath):
			pdb.gimp_image_remove_vectors(self.img, self.thispath)

class pyWSutils(gimpplugin.plugin):
	def start(self):
		gimp.main(self.init, self.quit, self.query, self._run)
	def init(self):
		pass
	def quit(self):
		pass
	def query(self):
		author = "jfgarcia"
		cright = "jfgarcia"
		date = "2013-2014"
		plug_descr = _("Create paths centered on the current selection")
		plug_params = [(PDB_INT32, "run_mode", "Run mode"), (PDB_IMAGE, "image", "Input image"),]
		gimp.install_procedure("path_shape_creator5", plug_descr, plug_descr, author, cright, date, _("<Image>/Filters/Path/path shape creator..."), "RGB*, GRAY*", PLUGIN, plug_params,[])

	def path_shape_creator5(self, runmode, img):
		sVecUtls(runmode, img)

if __name__ == '__main__':
	pyWSutils().start()
#