from __main__ import *

def computeDpt(r1, r2, theta):
	dpt_sin = math.pow(r1*math.sin(theta), 2)
	dpt_cos = math.pow(r2*math.cos(theta), 2)
	return math.sqrt(dpt_sin + dpt_cos)

def elliVerts(r1,r2,n):
	theta = 0.0
	twoPi = math.pi*2.0
	deltaTheta = 0.0001
	deltaTheta = 0.01
	numIntegrals = math.floor(twoPi/deltaTheta)
	circ=0.0
	dpt=0.0
	i=0
	while(i<numIntegrals):
		theta += i*deltaTheta
		dpt = computeDpt( r1, r2, theta)
		circ += dpt
		i=i+1
	nextPoint = 0
	run = 0.0
	theta = 0.0
	pnts=[]
	i = 0
	while(i<numIntegrals):
		theta += deltaTheta
		subIntegral = n*run/circ
		if (int(subIntegral) >= nextPoint):
			pnts.append([r1 * math.cos(theta),r2 * math.sin(theta)])
			nextPoint+=1
		run += computeDpt(r1, r2, theta)
		i+=1
	return pnts

def spikeElliStar(p1,p2,height):
	pp=pnt2d(0,height)
	pcent=pnt2d((p1.x+p2.x)/2,(p1.y+p2.y)/2)
	deltaY = p2.y - p1.y
	deltaX = p2.x - p1.x

	angleInDegrees = math.atan(deltaY / deltaX) * 180 / math.pi
	if ((p1.y>p2.y) and (p1.x<p2.x)):
		angleInDegrees=180+angleInDegrees
	elif ((p1.y<p2.y) and (p1.x<p2.x)):
		angleInDegrees=180+angleInDegrees

	pp.rotdeg(angleInDegrees)
	pp.translate(pcent.x,pcent.y)
	return pp

def shapeElliStar(x1,x2,y1,y2,v1,v2,v3,v5,v4,v6):
	an=(x2-x1)/2.0
	al=(y2-y1)/2.0
	bezs=[]
	msgTit=""
	msg=""
	#pts=elliVerts(an,al,v3*2)
	pts=elliVerts(an-v1,al-v1,v3)
	for n in range(len(pts)-1):
		p1= pnt2d(pts[n][0],pts[n][1])
		p2= pnt2d(pts[n+1][0],pts[n+1][1])
		pp=spikeElliStar(p1,p2,v1)
		bezs.append(bezpnt(pts[n]))
		bezs.append(bezpnt(pp))
	p1= pnt2d(pts[len(pts)-1][0],pts[len(pts)-1][1])
	p2= pnt2d(pts[0][0],pts[0][1])
	pp=spikeElliStar(p1,p2,v1)
	bezs.append(bezpnt(p1))
	bezs.append(bezpnt(pp))
	bezs=centerBezs(bezs,x1,y1,(x2-x1),(y2-y1))
	return [_("EllipStar")+str(v3),bezs,msgTit,msg,True]

def shapeElliPoly(x1,x2,y1,y2, v1,v2,v3,v5,v4,v6):
	an=(x2-x1)/2.0
	al=(y2-y1)/2.0
	bezs=[]
	msgTit=""
	msg=""
	pts=elliVerts(an,al,v3)
	for n in pts:
		bezs.append(bezpnt(n))
	bezs=centerBezs(bezs,x1,y1,(x2-x1),(y2-y1))
	return [_("EllipsPoly")+str(v3),bezs,msgTit,msg,True]

SHAPES2['ellistar']={'tit':_('Star ellipse'),'def':shapeElliStar,'labels':[_("Points height (px):"),"-",[_("Points:"),3],_("Roundness:"),"-","-"]}
SHAPES2['ellipoly']={'tit':_('Polygon ellipse'),'def':shapeElliPoly,'labels':[_("Points height (px):"),"-",[_("Points:"),3],_("Roundness:"),"-","-"]}
