from __main__ import *

def sphere_line_intersection(pointA,pointB,center,radius):
	baX = pointB.x - pointA.x;
	baY = pointB.y - pointA.y;
	caX = center.x - pointA.x;
	caY = center.y - pointA.y;
	a = baX * baX + baY * baY
	bBy2 = baX * caX + baY * caY
	c = caX * caX + caY * caY - radius * radius
	pBy2 = bBy2 / a
	q = c / a
	disc = pBy2 * pBy2 - q
	if (disc < 0): return (None,None)
	tmpSqrt = math.sqrt(disc);
	abSclFactor1 = -pBy2 + tmpSqrt
	abSclFactor2 = -pBy2 - tmpSqrt
	p1 = pnt2d(pointA.x - baX * abSclFactor1, pointA.y - baY * abSclFactor1)
	if (disc == 0): return (p1,None)
	p2 = pnt2d(pointA.x - baX * abSclFactor2, pointA.y - baY * abSclFactor2)
	return (p1, p2)

def angBetween2pnts(P1,P2):
	rot=0.0
	deltaY = P2.y - P1.y
	deltaX = P2.x - P1.x
	try:
		rot = math.atan2(deltaY, deltaX)
	except Exception,e:
		debugErr(e)
	if rot<0: rot=rot+2*math.pi
	return rot

def shapeSpeech(x1,x2,y1,y2, v1,v2,v3,v5,v4,v6):
	bezs=[]
	an, al=(x2 - x1, y2 - y1)
	an2, al2=(an/2, al/2)
	try:
		pnt2=[bezpnt(pnt2d(-v2,-v1)),bezpnt(pnt2d(-v2,v1)),bezpnt(pnt2d(v2,0))]
		#point in ellipse at angle
		rt = math.radians(v3)
		r = (an2*al2)/(math.sqrt(math.pow(al2*math.cos(rt),2)+math.pow(an2*math.sin(rt),2)))
		XX,YY=(r*math.cos(rt),r*math.sin(rt))
		rel=an/al
		if an>al:
			rel=an/al
			sx,sy,sx2,sy2,cr=(1,rel,1,1/rel,an/2)
		else:
			rel=al/an
			sx,sy,sx2,sy2,cr=(rel,1,1/rel,1,al/2)
		for n in pnt2: n.rotate(rt).translate(XX+an2,YY+al2).scale(sx,sy).translate(x1,y1)
		p1,p2,pr=(pnt2[1].fixed, pnt2[2].fixed, pnt2d(cr+x1,cr+y1))
		z1,z2=(pnt2[0].fixed, pnt2[2].fixed)
		n1,n2=sphere_line_intersection(p1, p2, pr, cr)
		w1,w2=sphere_line_intersection(z1, z2, pr, cr)
		rot,rot2=(angBetween2pnts(pr,n2),angBetween2pnts(pr,w2))

		arcs2=[math.radians(n) for n in [0,90,180,270,359.99]]
		ppp=[]
		point=bezpnt([p2.x,p2.y]).translate(-(cr+x1),-(cr+y1))
		for n in range(len(arcs2)-1,0,-1):
			if arcs2[n]>rot2 and arcs2[n]<rot: arcs2.remove(arcs2[n])
		arcs2.extend([rot,rot2])
		arcs2=sorted(arcs2)
		for n in range(0,len(arcs2)-1):
			pp1=arcs2[n]
			pp2=arcs2[n+1]
			if pp1<>rot2 or pp2<>rot:
				ppp.extend(createArcBez(cr, arcs2[n], arcs2[n+1]))
			else:
				ppp.extend([point])
		for n in ppp:n.scale(sx2,sy2).translate(cr*sx2+x1,cr*sy2+y1)
		bezs=ppp
	except Exception,e:
		debugErr(e)

	return [_("SpeechBub")+str(v3),bezs,'','',True]

SHAPES2['speech']={'tit':_('Speech Bubble'),'def':shapeSpeech,'labels':[[_("Point width")+' (px):',2.0],[_("Point height")+' (px):',2.0],[_("Point rotation")+':',0.0],"-","-","-"]}
