#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#    This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <https://www.gnu.org/licenses/>.

import os
import gettext
import sys
import drawUI
from gi.repository import Gtk
from gi.repository import GLib
from gi.repository import GimpUi
from gi.repository import Gimp
import gi
gi.require_version('Gimp', '3.0')
gi.require_version('GimpUi', '3.0')
gi.require_version('Gegl', '0.4')
gi.require_version('Gtk', '3.0')

thisPth = os.path.dirname(sys.argv[0]) + os.sep
gettext.install("arakne-guides-lab", thisPth + 'locale')


def N_(message): return message


def Between(Num, Max):
    if Num < 0:
        return 0
    if Num > Max:
        return Max
    return Num


class AdminGuides (Gimp.PlugIn):
    tabs = []
    tabTits = [_('Add/Edit'), _('Help')]
    titDel = _("X")
    newG = _("Add new")
    tipPos = _("Position of the current guide, double click on the value to edit")
    tipMeasure = _("Position of the current guide in ")
    tipDel = _("Double click to delete the current guide.")
    newGuideTip = _(
        "Write the position for the new guide\nLook what operations and replacements you can use in the help tab")
    REPEAT = [[_('None'), 0], [_('Mirror'), 1], [
        _('Perimeter'), 2], [_('Repeat'), 3]]
    REPEAT_hlp = [_("No repeat"), _("Replicate on the oposite side"), _("Replicate in the four sides"),
                  _("Add guides until it reaches the width or height of the image")]
    repeatn = 0
    newAt = _('New guide at')
    addOpposite = _("Add an aditional guide on the oposite side")
    measures = [['px', 0], ['%', 1], ['cm', 2], ['mm', 3], ['in', 4]]
    measure = 0
    repW = ['Width', 'width', 'W', 'w']
    repH = ['Height', 'height', 'H', 'h']
    img = None

    ui = drawUI.drawUi()

    def do_query_procedures(self):
        return ["plug-in-guides-lab"]

    def addObj(self, obj, props, show=False):
        o = obj
        for n in props:
            o.set_property(n, props[n])
        if show == True:
            o.show()
        return o

    def onEditGuide(self, widget, path, value, treeSt, name):
        v = int(self.parseVal(value))
        ts = treeSt
        if int(ts[path][0]) == int(v):
            return
        self.img.delete_guide(ts[path][1])
        if name == "h":
            hid = self.img.add_hguide(min(v, self.img.get_height()))
        else:
            hid = self.img.add_vguide(min(v, self.img.get_width()))
        ts[path][1] = hid
        ts[path][0] = v
        self.printNext(ts)

    def addCol(self, tv, title, renderer, pos, postx, tip, sortCol=None, w=None):
        col = Gtk.TreeViewColumn(title, renderer, text=postx)
        label = Gtk.Label(title)
        label.set_tooltip_text(tip)
        col.set_widget(label)
        if w:
            col.set_sizing(Gtk.TreeViewColumnSizing.FIXED)
            col.set_fixed_width(w)
        label.show()
        tv.insert_column(col, pos)
        if sortCol != None:
            col.set_sort_column_id(sortCol)

    def delGuide(self, widget, row, col):
        tit = col.get_title()
        treeSt = widget.get_model()
        if tit == self.titDel:
            id, gPos, i = (treeSt[row][1], treeSt[row][0], self.img)
            # comprobar que existe, puede haber sido borrada manualmente
            dir = 0 if treeSt.get_name() == 'ts_h' else 1
            g = i.find_next_guide(0)
            existe = False
            while (g > 0):
                if (i.get_guide_orientation(g) == dir and i.get_guide_position(g) == gPos):
                    existe = True
                    break
                g = i.find_next_guide(g)
            if existe == True:
                self.img.delete_guide(id)
            for fila in treeSt:
                if fila[1] == id:
                    treeSt.remove(fila.iter)
                    self.printNext(treeSt)
                    break

    def printNext(self, ts):
        if len(ts) == 0:
            return
        iH, iW = (self.img.get_height(), self.img.get_width())
        res = self.img.get_resolution()[1]
        ts.set_sort_column_id(0, Gtk.SortType.ASCENDING)
        name = ts.get_name()
        for n in range(0, len(ts)):
            ts[n][2] = str(round(
                (100.0 / (iH if name == "ts_h" else iW)) * ts[n][0], 2))
            ts[n][3] = str(round(ts[n][0] * 25.4 / res, 2))
            ts[n][4] = str(round(ts[n][0] * 2.54 / res, 2))
            ts[n][5] = str(round(ts[n][0] / res, 2))

    def addTV(self, name):
        tS = Gtk.ListStore(int, int, str, str, str, str, float)
        tS.set_name("ts_"+name)
        tv = self.addObj(Gtk.TreeView(
            tS), {"name": name, "rules-hint": True, "show-expanders": False}, True)
        tv.set_size_request(300, 240)
        rendImg = self.addObj(Gtk.CellRendererPixbuf(), {
                              'stock-id': Gtk.STOCK_DELETE})
        rendSpin = Gtk.CellRendererSpin()
        rendSpin.connect("edited", self.onEditGuide, tS, name)
        maxVal = self.img.get_height() if name == 'h' else self.img.get_width()
        self.ui.addProps(rendSpin, [
                         ("editable", True), ("adjustment", Gtk.Adjustment(0, 0, maxVal, 1, 10, 0))])
        rendTx = self.addObj(Gtk.CellRendererText(), {"editable": False})
        self.addCol(tv, "px", rendSpin, 0, 0, self.tipPos, 0, 54)
        self.addCol(tv, "%", rendTx,  1, 2, self.tipMeasure + "%", None, 54)
        self.addCol(tv, "mm", rendTx,  2, 3, self.tipMeasure + "mm", None, 54)
        self.addCol(tv, "cm", rendTx,  3, 4, self.tipMeasure + "cm", None, 54)
        self.addCol(tv, "in", rendTx,  4, 5, self.tipMeasure + "in", None, 54)
        self.addCol(tv, "X", rendImg, 5, -1, self.tipDel, None, 20)

        tv.set_grid_lines(Gtk.TreeViewGridLines.BOTH)
        tv.connect('row-activated', self.delGuide)
        selection = tv.get_selection()
        selection.set_mode(Gtk.SelectionMode.SINGLE)
        sW = self.addObj(
            Gtk.ScrolledWindow(hadjustment=None, vadjustment=None), {
                "shadow-type": Gtk.ShadowType.IN,
                "vscrollbar-policy": Gtk.PolicyType.AUTOMATIC,
                "hscrollbar-policy": Gtk.PolicyType.AUTOMATIC})
        sW.add(tv)
        sW.show()
        sW.set_size_request(300, 240)
        return (tS, tv, sW)

    def evalSpin(self, widget, data=None):
        widget.set_value(self.parseVal(widget.get_text()))

    def tt(self, w, data=None):
        v = self.parseVal(w.get_text())
        w.set_value(v)

    def spinBtnGuidePos(self, Range):
        ADJ = Gtk.Adjustment(value=0, lower=-Range,
                             upper=Range, step_increment=1)
        sb = Gtk.SpinButton(adjustment=ADJ, climb_rate=0.0, digits=0)
        sb.connect("focus-out-event", self.tt)
        sb.set_tooltip_text(self.newGuideTip)
        return sb

    def toPX(self, unit, v, hw):
        res = self.img.get_resolution()[1]
        if unit == 1:
            v = hw / 100.0 * v
        if unit == 2:
            v = int(v / 2.54 * res)
        if unit == 3:
            v = int(v / 25.4 * res)
        if unit == 4:
            v = int(v * res)
        if v < 0.0:
            v = hw + v
        return v

    def tabHelp(self, tab):
        row = 0
        tta = "<span foreground='blue' background='white'> <tt>"
        ttb = "</tt> </span>"
        hrepW = ", ".join(["<b>" + nn + "</b>" for nn in self.repW])
        hrepH = ", ".join(["<b>" + nn + "</b>" for nn in self.repH])
        msgs = [
            _("Double click on the <b>%s</b> cell for delete the guide.") % ("X")+"\n",
            _("Use negative values to add guides on the oposite side.")+"\n",
            "<b>"+_("In the text fields you can use the following shortcuts:")+"</b>",
            _("%s:\n\tReplaced by the width of the current selected image") % hrepW,
            _("%s:\n\tReplaced by the height of the current selected image") % hrepH + "\n",
            "<b>"+_("SAMPLES OF USAGE:")+"</b>",
            "\t"+_("For add a guide on the vertical center:") +
            tta + "h/2" + ttb,
            "\t"+_("For add a guide at 10 pixels of the bottom:") +
            tta + "H-10" + ttb,
            "\t"+_("For add a guide at 10 pixels of the center") +
            ":" + tta + "height/2+10" + ttb
        ]
        tx = ""
        for line in msgs:
            tx += line+"\n"
        lb = self.ui.addRows(self.ui.addLabel(tx, 0, 0), tab, 2, 4, row, row+1)
        lb.set_property("margin", 20)
        lb.set_use_markup(True)

    def addG(self, v, hv):
        v = int(v)
        if self.guideExists(v, hv):
            return
        if hv == 'h':
            hid = self.img.add_hguide(v)
            tree = self.tsH
        else:
            hid = self.img.add_vguide(v)
            tree = self.tsV
        tree.append([v, hid, "0", "0", "0", "0", 0])
        self.printNext(tree)

    def parseVal(self, val):
        s = val
        if s == self.newG:
            s = '0'
        for nn in self.repW:
            s = s.replace(nn, str(self.img.get_width()))
        for nn in self.repH:
            s = s.replace(nn, str(self.img.get_height()))
        return eval(s)

    def guideExists(self, v, direction):
        i = self.img
        g = i.find_next_guide(0)
        dir = 0 if direction == 'h' else 1
        while (g > 0):
            if i.get_guide_orientation(g) == dir:
                pos = i.get_guide_position(g)
                if pos == v:
                    return True
            g = i.find_next_guide(g)
        return False

    def _h(self):
        return self.img.get_height()

    def _w(self):
        return self.img.get_width()

    def tval(self, tx):
        return float(self.parseVal(tx.get_text()))

    def addH(self, widget):
        val, h, w = (self.tval(self.newH), self._h(), self._w())
        unit = self.measure
        v = self.toPX(unit, val, h)
        self.addG(Between(v, h), 'h')
        repli = self.repeat_n
        if repli == 3:
            v2 = v+v
            while v2 < self._h():
                self.addG(Between(v2, h), 'h')
                v2 += v
        else:
            if repli > 0:
                center = h / 2.0
                if v != center:
                    self.addG(Between(h - v, h), 'h')
            if repli == 2:
                val = self.toPX(unit, abs(val), w)
                self.addG(Between(val,     w), 'v')
                self.addG(Between(w - val, w), 'v')

    def addV(self, widget):
        val, w, h = (self.tval(self.newV), self._w(), self._h())
        unit = self.measure
        v = self.toPX(unit, val, w)
        self.addG(Between(v, w), 'v')
        repli = self.repeat_n
        if repli == 3:
            v2 = v+v
            while v2 < self._w():
                self.addG(Between(v2, w), 'v')
                v2 += v
        else:
            if repli > 0:
                if v != w / 2.0:
                    self.addG(Between(w - v, w), 'v')
            if repli == 2:
                val = self.toPX(unit, abs(val), h)
                self.addG(Between(val,     h), 'h')
                self.addG(Between(h - val, h), 'h')

    def getGuides(self, widget=None):
        i = self.img
        lH = []
        lV = []
        TSs = [self.tsH, self.tsV]
        for n in TSs:
            n.clear()
        g = i.find_next_guide(0)
        while (g > 0):
            lst = lH if i.get_guide_orientation(g) == 0 else lV
            lst.append([i.get_guide_position(g), g, "0", "0", "0", "0", 0])
            g = i.find_next_guide(g)
        lH.sort(key=lambda tup: tup[0])
        lV.sort(key=lambda tup: tup[0])
        [self.tsH.append(n) for n in lH]
        [self.tsV.append(n) for n in lV]
        [self.printNext(n) for n in TSs]

    def delGuides(self, widget=None):
        i = self.img
        all = []
        g = i.find_next_guide(0)
        while (g > 0):
            all.append(g)
            g = i.find_next_guide(g)
        for i in reversed(all):
            self.img.delete_guide(i)
        self.getGuides()

    def rBtns(self, values, parent, onchange=None, label="", tips=[]):
        if label != "":
            lbl = Gtk.Label(label=label)
            parent.pack_start(lbl, False, False, 0)
            lbl.show()
        rbParent = None
        i = 0
        for n in values:
            if rbParent == None:
                rb = Gtk.RadioButton.new_with_label(rbParent, n[0])
                rb.set_active(True)
                rbParent = rb
            else:
                rb = Gtk.RadioButton.new_from_widget(rbParent)
                rb.set_label(n[0])
            if len(tips) > i:
                rb.set_tooltip_text(tips[i])
            rb.show()
            if onchange:
                rb.connect("toggled", onchange, n[1])
            parent.pack_start(rb, False, False, 0)
            i = i+1

    def tabOne(self):
        row = 0
        tab0 = self.tabs[0]
        labH = self.ui.addLabel(" " + " \n ".join(list(_("HORIZONTAL"))), 0.5)
        self.ui.addRows(labH, tab0, 0, 1, row, 1)
        self.tsH, tvh, sWh = self.addTV('h')
        self.ui.addRows(sWh, tab0, 1, 3, row, 1)
        labV = self.ui.addLabel(" " + " \n ".join(list(_("VERTICAL"))), 0.5)
        self.ui.addRows(labV, tab0, 4, 1, row, 1)

        self.tsV, tvv, sWv = self.addTV('v')
        self.ui.addRows(sWv, tab0, 5, 3, row, 1)

        row += 1
        self.ui.addRows(self.ui.addLabel(self.newAt), tab0, 1, 1, row, 1)
        self.newH = self.ui.addRows(self.spinBtnGuidePos(
            self.img.get_height()), tab0, 2, 1, row, 1, "activate", self.evalSpin)
        btnh = Gtk.Button()
        btnh.set_label('Add')

        self.newHB = self.ui.addRows(
            btnh, tab0, 3, 1, row, 1, "clicked", self.addH)

        self.ui.addRows(self.ui.addLabel(self.newAt), tab0, 5, 1, row, 1)
        self.newV = self.ui.addRows(self.spinBtnGuidePos(
            self.img.get_width()), tab0, 6, 1, row, 1, "activate", self.evalSpin)
        self.newV.connect("focus-out-event", self.tt)
        btnv = Gtk.Button()
        btnv.set_label('Add')
        self.newVB = self.ui.addRows(
            btnv, tab0, 7, 1, row, 1, "clicked", self.addV)
        self.getGuides()

        row += 1
        vbox2 = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=10)
        self.ui.addRows(vbox2, tab0, 1, 6, row, 1)
        self.rBtns(self.measures, vbox2, self.chMeasure, _("New guides in:"))
        row += 1
        vbox2.show()

        vboxRep = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=10)
        self.ui.addRows(vboxRep, tab0, 1, 6, row, 1)
        self.rBtns(self.REPEAT, vboxRep, self.chRepeat,
                   _("Replicate:"), self.REPEAT_hlp)
        vboxRep.show()
        row += 2
        self.ui.addRows(Gtk.Button(_('Update manual changes')),
                        tab0, 1, 3, row, 1, 'clicked', self.getGuides)
        self.ui.addRows(Gtk.Button(_('Delete all guides')), tab0,
                        5, 3, row, 1, 'clicked', self.delGuides)

    def chMeasure(self, button, name):
        if button.get_active():
            self.measure = name

    def chRepeat(self, button, name):
        if button.get_active():
            self.repeat_n = name

    def do_create_procedure(self, name):
        proc = Gimp.ImageProcedure.new(
            self, name, Gimp.PDBProcType.PLUGIN, self.run, None)
        proc.set_image_types("*")
        proc.set_sensitivity_mask(Gimp.ProcedureSensitivityMask.DRAWABLE)
        proc.set_menu_label(_("Admin Guides"))
        proc.set_icon_name(GimpUi.ICON_GEGL)
        proc.add_menu_path('<Image>/Image/Guides/')
        proc.set_documentation(
            _("Admin Guides"), _("Admin Guides"), name)
        proc.set_attribution("Paco Garcia", "Paco Garcia", "2025")
        return proc

    def run(self, procedure, run_mode, image, drawables, config, run_data):
        if len(drawables) != 1:
            msg = _("Procedure '{}' only works with one drawable.").format(
                procedure.get_name())
            error = GLib.Error.new_literal(Gimp.PlugIn.error_quark(), msg, 0)
            return procedure.new_return_values(Gimp.PDBStatusType.CALLING_ERROR, error)

        self.img = image

        if run_mode == Gimp.RunMode.INTERACTIVE:
            GimpUi.init("admin-guides")
            dialog = GimpUi.Dialog(use_header_bar=True, title=_(
                "Admin Guides"), role="admin-guides")
            dialog.add_button(_("_Cancel"), Gtk.ResponseType.CANCEL)
            dialog.set_default_size(500, 350)
            dialog.set_border_width(5)
            dialog.set_keep_above(True)
            dialog.connect("destroy", Gtk.main_quit)
            box = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=20)
            dialog.get_content_area().add(box)
            box.show()

            self.nB = Gtk.Notebook()
            box.pack_start(self.nB, False, False, 1)
            self.nB.show()

            for n in range(0, len(self.tabTits)):
                t = self.addObj(Gtk.Grid(), {}, True)
                self.tabs.append(t)
                tabTit = Gtk.Label(self.tabTits[n])
                tabTit.set_property("margin", 12)
                self.nB.append_page(self.tabs[n], tabTit)

            self.tabOne()
            self.tabHelp(self.tabs[1])
            while (True):
                response = dialog.run()
                if response == Gtk.ResponseType.CANCEL:
                    dialog.destroy()
                    return procedure.new_return_values(Gimp.PDBStatusType.CANCEL,  GLib.Error())
        return procedure.new_return_values(Gimp.PDBStatusType.SUCCESS, GLib.Error())


Gimp.main(AdminGuides.__gtype__, sys.argv)
