#!/usr/bin/env python
# -*- coding: utf-8 -*-
from gi.repository import Gimp
from gi.repository import Gtk
import gi
gi.require_version('Gtk', '3.0')
gi.require_version('Gimp', '3.0')

import traceback

def dbg(aaa):
    Gimp.message(str(aaa))

def defIndex(arr, index, alt=None):
    if len(arr) > index:
        return arr[index]
    else:
        return alt

def detError(e):
    Gimp.message(f"Error: {e}")
    Gimp.message(traceback.format_exc())


class drawUi(object):
    def __init__(self):
        pass

    def addRows(self, obj, table, col1, col2, row1, row2, cnn="", function=None):
        try:
            table.attach(obj, col1, row1, col2,  row2)
            table.set_row_spacing(10)
            table.set_column_spacing(10)
        except Exception:
            Gimp.message(str(Exception))
        obj.show()
        if cnn != "":
            obj.connect(cnn, function)
        return obj

    def addObjs(self, arrobj, table):
        # ToDo: revisar
        objs = []
        for data in arrobj:
            if type(data) is list:
                obj = data[0]
                if type(obj) is str or type(obj) is unicode:
                    obj = self.addLabel(obj)
                col1 = defIndex(data, 1)
                col2 = defIndex(data, 2)
                row1 = defIndex(data, 3)
                row2 = defIndex(data, 4)
                cnn = defIndex(data, 5, '')
                fn = defIndex(data, 6)
                objs.append(self.addRows(obj, table, col1,
                            col2, row1, row2, cnn, fn))
            if type(data) is int:
                objs.append(data)
        return objs

    def addProps(self, obj, props):
        for Key, Value in props:
            obj.set_property(Key, Value)

    def addLabel(self, tx, alignx=1.0, aligny=0.5, tip=""):
        lb = Gtk.Label(tx)
        lb.set_alignment(alignx, aligny)
        if tip!="":
            lb.set_tooltip_text(tip)
        return lb

    def fillCombo(self, Store, combobox):
        st = combobox.get_model()
        st.clear()
        for n in Store:
            st.append(n)
        combobox.set_model(st)
        combobox.set_active(0)

    def fillCombo2(self, Store, combobox):
        st = combobox.get_model()
        st.clear()
        for n in Store:
            st.append([Store[n]['tit'], n])
        combobox.set_model(st)
        combobox.set_active(0)

    def makeCombo(self, Store):
        st = Gtk.ListStore(str, int)
        self.cmb = Gtk.ComboBox.new_with_model(st)
        cell = Gtk.CellRendererText()
        self.fillCombo(Store, self.cmb)
        self.cmb.pack_start(cell, True)
        self.cmb.add_attribute(cell, 'text', 0)
        self.cmb.set_active(0)
        return self.cmb

    def makeCombo2(self, Store):
        st = Gtk.ListStore(str, str)
        self.cmb = Gtk.ComboBox.new_with_model(st)
        cell = Gtk.CellRendererText()
        self.fillCombo2(Store, self.cmb)
        self.cmb.pack_start(cell, True)
        self.cmb.add_attribute(cell, 'text', 0)
        self.cmb.set_active(0)
        return self.cmb

    def table(self, rows=1, columns=1, homogeneous=False, row_s=2, col_s=2):
        tab = Gtk.Table(rows, columns, homogeneous)
        tab.set_row_spacings(row_s)
        tab.set_col_spacings(col_s)
        tab.show()

    def getValues(self, arrFields):
        return (n.get_value() for n in arrFields)

    def getModelVal(self, widget):
        iter = widget.get_active_iter()
        model = widget.get_model()
        lP = model.get_value(iter, 1)
        return lP
