import gi
gi.require_version('Gtk', '3.0')
from gi.repository import Pango
import re
import keyword

class PySynHighligh():
    def __init__(self, textView):
        self.txbuff = textView
        self._setup_tags()
        self.python_keywords = keyword.kwlist
        self.keyword_pattern = re.compile(r'\b(' + '|'.join(re.escape(kw) for kw in self.python_keywords) + r')\b')
        self.txbuff.connect("changed", self._on_text_buffer_changed)

    def _setup_tags(self):
        self.keyword_tag = self.txbuff.create_tag("keyword", foreground="#008080", weight=Pango.Weight.BOLD)
        self.string_tag = self.txbuff.create_tag("string", foreground="#80ff00")
        self.comment_tag = self.txbuff.create_tag("comment", foreground="#000000", background="#808080",style=Pango.Style.ITALIC)
        # Puedes añadir más tags para números, funciones, etc.

    def _on_text_buffer_changed(self, textbuffer):
        self.txbuff.disconnect(self._on_text_buffer_changed_handler_id)
        self._apply_syntax_highlighting()
        self._on_text_buffer_changed_handler_id = self.txbuff.connect("changed", self._on_text_buffer_changed)

    def _apply_syntax_highlighting(self):
        start_iter = self.txbuff.get_start_iter()
        end_iter = self.txbuff.get_end_iter()

        self.txbuff.remove_tag(self.keyword_tag, start_iter, end_iter)
        self.txbuff.remove_tag(self.string_tag, start_iter, end_iter)
        self.txbuff.remove_tag(self.comment_tag, start_iter, end_iter)
        full_text = self.txbuff.get_text(start_iter, end_iter, True)

        for match in re.finditer(r'#.*$', full_text, re.M):
            start_offset, end_offset = match.span()
            start_iter_comment = self.txbuff.get_iter_at_offset(start_offset)
            end_iter_comment = self.txbuff.get_iter_at_offset(end_offset)
            self.txbuff.apply_tag(self.comment_tag, start_iter_comment, end_iter_comment)

        for match in re.finditer(r'("""[^"]*""")|(\'\'\'[^\']*\'\'\')', full_text, re.DOTALL):
            start_offset, end_offset = match.span()
            start_iter_comment = self.txbuff.get_iter_at_offset(start_offset)
            end_iter_comment = self.txbuff.get_iter_at_offset(end_offset)
            self.txbuff.apply_tag(self.comment_tag, start_iter_comment, end_iter_comment)

        for match in re.finditer(r'(".*?")|(\'.*?\')', full_text):
            start_offset, end_offset = match.span()
            start_iter_string = self.txbuff.get_iter_at_offset(start_offset)
            end_iter_string = self.txbuff.get_iter_at_offset(end_offset)
            if not start_iter_string.has_tag(self.comment_tag):
                self.txbuff.apply_tag(self.string_tag, start_iter_string, end_iter_string)

        for match in self.keyword_pattern.finditer(full_text):
            start_offset, end_offset = match.span()
            start_iter_keyword = self.txbuff.get_iter_at_offset(start_offset)
            end_iter_keyword = self.txbuff.get_iter_at_offset(end_offset)
            check_iter = self.txbuff.get_iter_at_offset(start_offset)
            if not check_iter.has_tag(self.comment_tag) and not check_iter.has_tag(self.string_tag):
                self.txbuff.apply_tag(self.keyword_tag, start_iter_keyword, end_iter_keyword)

        self._on_text_buffer_changed_handler_id = self.txbuff.connect("changed", self._on_text_buffer_changed)
