import os
import json

class GimpShelf:
    def __init__(self, file_path, encoding='utf-8'):
        self.file_path = file_path
        self.encoding = encoding

    def file_exists(self):
        return os.path.isfile(self.file_path)
    
    def read_all(self):
        if not self.file_exists():
            return None
        try:
            with open(self.file_path, 'r', encoding=self.encoding) as f:
                content = f.read()
                return json.loads(content)
        except Exception:
            return {}

    def write(self, content, mode='w'):
        if mode not in ['w', 'a']:
            return False
        try:
            dir_name = os.path.dirname(self.file_path)
            if dir_name and not os.path.exists(dir_name):
                os.makedirs(dir_name)

            with open(self.file_path, mode, encoding=self.encoding) as f:
                #f.write(json.dumps(content))
                json.dump(content, f, indent=4)

                return True
        except Exception:
            return False


def snippet_add(sh, grpname, tit, code):
    try:
        gname=grpname.strip()
        tit=tit.strip()
        code=code.strip()
        print(gname)
        print(tit)
        print(code)
        l=None
    except Exception:
        print(Exception)
    if gname!="" and tit!="" and code!="":
        print("todo ok")
        lista=sh.read_all()
        for snp in lista:
            if snp.get("t") == gname:
                l=snp.get("l")
                break
        if l==None:
            lista.append({"t":gname, "l":[]})
            l=lista[-1].get("l")
        print("guardamos "+str({"t": tit, "c": code}))
        l.append( {"t": tit, "c": code})
        sh.write(lista)
    else:    
        return None

def snipped_add(lista, new_snp):
    existe = any(p.get("nombre") == new_snp["nombre"] for p in lista)
    if not existe:
        lista.append(new_snp)
        print("Persona añadida:", new_snp)
    else:
        print("Ya existe una persona con ese nombre.")

#añadir_si_no_existe(personas, {"id": 4, "nombre": "Carlos", "edad": 35})


"""
[
    {
        "t": "Common",
        "l": [
            {
                "t": "Get 1st image",
                "c": "img1=Gimp.get_images()[0]"
            }
        ]
    },
    {
        "t": "Gtk",
        "l": [
            {
                "t": "All imports",
                "c": "from gi.repository import Gtk\nimport gi\ngi.require_version('Gtk', '3.0')\ngi.require_version('Gdk', '3.0')\ngi.require_version('Gimp', '3.0')"
            }
        ]
    }
]
"""