from gi.repository import Gtk
import gi
gi.require_version('Gtk', '3.0')
gi.require_version('Gdk', '3.0')
gi.require_version('Gimp', '3.0')


def gtkProps(obj, props):
    for n in props:
        obj.set_property(n, props[n])

def Gtk_(obj, props=None, p=None, show=True, cnn=None, fill=1, tt="", tm=""):
    o = obj
    if props: gtkProps(o, props)
    if tt!="": o.set_tooltip_text(tt)
    if tm!="": o.set_tooltip_markup(tm)
    if show == True: o.show()
    if p:
        if fill==0:
            p.pack_start(o, expand=False, fill=False, padding=3)
        else:
            p.add(o)
    if cnn:
        for n in cnn:
            o.connect(n, cnn[n])
    return o

def tvCol( tv, tit, colIndex):
    col = Gtk.TreeViewColumn(tit)
    tv.append_column(col)
    cell = Gtk.CellRendererText()
    col.pack_start(cell, True)
    col.add_attribute(cell, 'text', colIndex)
    col.set_sort_column_id(0)
    return col

def GtkTV(model, cols, props=None, parent=None, show=1, cnn=None, f=0, tt="", tm=""):
    tv = Gtk.TreeView(model = model)
    for i in range(0, len(cols)):
        tvCol(tv, cols[i], i)
    tv.set_reorderable(False)
    tv.set_search_column(0)
    tv_sel = tv.get_selection()
    tv_sel.set_mode(Gtk.SelectionMode.SINGLE)
    tv.set_grid_lines(Gtk.TreeViewGridLines.BOTH)
    return Gtk_(tv, props=props, p=parent, show=show, cnn=cnn, fill=f, tt=tt, tm=tm)


def GtkLb(tx, props=None, p=None, show=True, f=1):
    lb = Gtk.Label()
    lb.set_markup(tx)
    return Gtk_(lb, props=props, p=p, show=show, fill=f)

def GtkTx(tx, props=None, p=None, show=True, cnn=None, f=1, tt="", tm=""):
    o = Gtk.Entry()
    if tx != "":
        o.set_text(tx)
    return Gtk_(o, props, p=p, show=show, cnn=cnn, fill=f, tt=tt, tm=tm)

def GtkBtn(lb, props=None, p=None, show=True, cnn=None, f=1, tt="", tm=""):
    return Gtk_(Gtk.Button(label=lb), props=props, p=p, show=show, cnn=cnn, fill=f, tt=tt, tm=tm)

def GTKCbLab(lab, props=None, p=None, show=True, cnn=None, fill=1, tt="", tm=""):
    o = Gtk.CheckButton.new_with_label(lab)
    return Gtk_(o, props=props, p=p, show=show, cnn=cnn, fill=fill, tt=tt, tm=tm)

def scrollW(child=None, props=None, show=1, p=None, f=1):
    Scrl = Gtk_(Gtk.ScrolledWindow(), props=props, p=p, show=show, fill=f)
    Scrl.set_policy(Gtk.PolicyType.AUTOMATIC, Gtk.PolicyType.ALWAYS)
    Scrl.set_shadow_type(Gtk.ShadowType.IN)
    if child:
        Scrl.add(child)
    return Scrl

def lbEntry(parent, lb1, w2):
    vh = Gtk_(Gtk.HBox())
    parent.pack_start(vh, expand=False, fill=False, padding=3)
    GtkLb(lb1, {}, p=vh, f=0)
    vh.add(w2)
    return w2


def GtkCbox(ListStore, opts, props=None, show=1, p=None, f=1, cnn=None, tt="", tm=""):
    cmbox = Gtk.ComboBox.new_with_model(ListStore)
    cmb = Gtk_(cmbox, props=props, p=p, show=show, fill=f, cnn=cnn, tt=tt, tm=tm)
    cell = Gtk.CellRendererText()
    fillCombo(opts, cmb)
    cmb.pack_start(cell, True)
    cmb.add_attribute(cell, 'text', 0)
    cmb.set_active(0)
    return cmb

def fillCombo(Store, combobox):
    st = combobox.get_model()
    st.clear()
    for n in Store:
        st.append(n)
    combobox.set_model(st)
    combobox.set_active(0)

def showOnTop(widget):
    Gtk.Window.present(widget)
    widget.set_keep_above(True)

def bufferAdd(tb, tx, tag=None):
    p = tb.get_end_iter()
    if tag != None:
        tb.insert_with_tags(p, tx, tag)
    else:
        tb.insert(p, tx)

def TextViewGetAll(tv):
    tx=''
    try:
        bff = tv.get_buffer()
        start_iter = bff.get_start_iter()
        end_iter = bff.get_end_iter()
        tx=bff.get_text(start_iter, end_iter, False)
    except Exception as e:
        print(e)
    return tx


def dlgBtns(dlg, btns):
    for n in btns:
        Gtk.Dialog.add_button(dlg, n, btns[n])

def bufferDel(tx):
    tb = tx.get_buffer()
    ini, end = tb.get_bounds()
    tb.delete(ini, end)

def Tag(n, tx):
    arrn = n.split(",")
    cnt = str(tx)
    for t in arrn:
        cnt = f"<{t}>{cnt}</{t}>"
    return cnt

def bufferAll(tv):
    bfr = tv.get_buffer()
    return bfr.get_text(bfr.get_start_iter(), bfr.get_end_iter(), False)
