import os
import json

class GimpShelf:
    def __init__(self, file_path, encoding='utf-8'):
        self.file_path = file_path
        self.encoding = encoding

    def file_exists(self):
        return os.path.isfile(self.file_path)
    
    def read_all(self):
        if not self.file_exists():
            return None
        try:
            with open(self.file_path, 'r', encoding=self.encoding) as f:
                content = f.read()
                return json.loads(content)
        except Exception:
            return {}

    def write(self, content, mode='w'):
        if mode not in ['w', 'a']:
            return False
        try:
            dir_name = os.path.dirname(self.file_path)
            if dir_name and not os.path.exists(dir_name):
                os.makedirs(dir_name)

            with open(self.file_path, mode, encoding=self.encoding) as f:
                #f.write(json.dumps(content))
                json.dump(content, f, indent=4)

                return True
        except Exception:
            return False


def snippet_add(sh, grpname, tit, code):
    try:
        gname=grpname.strip()
        tit=tit.strip()
        code=code.strip()
        l=None
    except Exception:
        print(Exception)
    if gname!="" and tit!="" and code!="":
        lista=sh.read_all()
        for snp in lista:
            if snp.get("t") == gname:
                l=snp.get("l")
                break
        if l==None:
            lista.append({"t":gname, "l":[]})
            l=lista[-1].get("l")
        l.append( {"t": tit, "c": code})
        sh.write(lista)
    else:    
        return None

def snippet_del(sh, grpname, tit):
    if grpname!="" and tit!="":
        lista=sh.read_all()
        for snp in lista:
            if snp.get("t") == grpname:
                l=snp.get("l")
                i=0
                for ll in l:
                    if ll.get("t")==tit:
                        l.pop(i)
                        sh.write(lista)
                        return None
                    i+=1
    else:    
        return None

def snippet_del_grp(sh, grpname):
    if grpname!="":
        i = 0
        lista=sh.read_all()
        for snp in lista:
            if snp.get("t") == grpname:
                lista.pop(i)
                sh.write(lista)
                return None
            i+=1
    else:    
        return None
