from gi.repository import Gtk,Gdk
import gi
gi.require_version('Gtk', '3.0')
gi.require_version('Gdk', '3.0')
gi.require_version('Gimp', '3.0')


def gtkProps(obj, props):
    for n in props:
        obj.set_property(n, props[n])

def Gtk_(obj, props=None, p=None, show=True, cnn=None, fill=1, tt="", tm=""):
    o = obj
    if props: gtkProps(o, props)
    if tt!="": o.set_tooltip_text(tt)
    if tm!="": o.set_tooltip_markup(tm)
    if show == True: o.show()
    if p:

        if fill==0:
            p.pack_start(o, expand=False, fill=False, padding=3)
        else:
            p.add(o)
    if cnn:
        for n in cnn:
            o.connect(n, cnn[n])
    return o

def tvCol(tv, tit, colIndex):
    col = Gtk.TreeViewColumn(tit)
    tv.append_column(col)
    cell = Gtk.CellRendererText()
    col.pack_start(cell, True)
    col.add_attribute(cell, 'text', colIndex)
    col.set_sort_column_id(0)
    col.set_sizing(Gtk.TreeViewColumnSizing.AUTOSIZE)
    col.set_expand(True)
    return col

def GtkLb(tx, props=None, p=None, show=True, f=1):
    lb = Gtk.Label()
    lb.set_markup(tx)
    return Gtk_(lb, props=props, p=p, show=show, fill=f)

def GtkTx(tx, props=None, p=None, show=True, cnn=None, f=1, tt="", tm=""):
    o = Gtk.Entry()
    if tx != "":
        o.set_text(tx)
    return Gtk_(o, props, p=p, show=show, cnn=cnn, fill=f, tt=tt, tm=tm)

def GtkBtn(lb, props=None, p=None, show=True, cnn=None, f=1, tt="", tm=""):
    return Gtk_(Gtk.Button(label=lb), props=props, p=p, show=show, cnn=cnn, fill=f, tt=tt, tm=tm)

def GTKCbLab(lab, props=None, p=None, show=True, cnn=None, f=0, toggled=None, tt="", tm=""):
    o = Gtk.CheckButton.new_with_label(lab)
    if toggled:
        o.connect("toggled",toggled)
    return Gtk_(o, props=props, p=p, show=show, cnn=cnn, fill=f, tt=tt, tm=tm)

def scrollW(child=None, props=None, show=1, p=None, f=1):
    Scrl = Gtk_(Gtk.ScrolledWindow(), props=props, p=p, show=show, fill=f)
    Scrl.set_policy(Gtk.PolicyType.AUTOMATIC, Gtk.PolicyType.ALWAYS)
    Scrl.set_shadow_type(Gtk.ShadowType.IN)
    if child:
        Scrl.add(child)
    return Scrl

def lbEntry(parent, lb1, w2):
    vh = Gtk_(Gtk.HBox())
    parent.pack_start(vh, expand=False, fill=False, padding=3)
    GtkLb(lb1, {}, p=vh, f=0)
    vh.add(w2)
    return w2

def GtkCbox(ListStore, opts, props=None, show=1, p=None, f=1, cnn=None, tt="", tm=""):
    cmbox = Gtk.ComboBox.new_with_model(ListStore)
    cmb = Gtk_(cmbox, props=props, p=p, show=show, fill=f, cnn=cnn, tt=tt, tm=tm)
    cell = Gtk.CellRendererText()
    fillCombo(opts, cmb)
    cmb.pack_start(cell, True)
    cmb.add_attribute(cell, 'text', 0)
    cmb.set_active(0)
    return cmb

def fillCombo(Store, combobox):
    st = combobox.get_model()
    st.clear()
    for n in Store:
        st.append(n)
    combobox.set_model(st)
    combobox.set_active(0)

def showOnTop(widget):
    Gtk.Window.present(widget)
    widget.set_keep_above(True)

def bufferAdd(tb, tx, tag=None):
    p = tb.get_end_iter()
    if tag != None:
        tb.insert_with_tags(p, tx, tag)
    else:
        tb.insert(p, tx)

def TextViewGetAll(tv):
    tx=''
    try:
        bff = tv.get_buffer()
        start_iter = bff.get_start_iter()
        end_iter = bff.get_end_iter()
        tx=bff.get_text(start_iter, end_iter, False)
    except Exception as e:
        print(e)
    return tx

def dlgBtns(dlg, btns):
    for n in btns:
        Gtk.Dialog.add_button(dlg, n, btns[n])

def bufferDel(tx):
    tb = tx.get_buffer()
    ini, end = tb.get_bounds()
    tb.delete(ini, end)

def bufferAdd(widget, tx):
    buffer = widget.get_buffer()
    end_iter = buffer.get_end_iter()
    buffer.insert(end_iter, tx)
    widget.grab_focus()

def Tag(n, tx):
    arrn = n.split(",")
    cnt = str(tx)
    for t in arrn:
        cnt = f"<{t}>{cnt}</{t}>"
    return cnt

def bufferAll(tv):
    bfr = tv.get_buffer()
    return bfr.get_text(bfr.get_start_iter(), bfr.get_end_iter(), False)

def get_icon_pixbuf(icon_name, size=16):
    theme = Gtk.IconTheme.get_default()
    return theme.load_icon(icon_name, size, 0)

def listIcons():
    theme = Gtk.IconTheme.get_default()
    all = theme.list_icons()
    all.sort()
    listOpts=[]
    for n in all:
        clean=n[0:n.find("-")]
        if n.find("-")==-1: clean=n
        listOpts.append(clean)
    listOpts = list(set(listOpts))
    listOpts.sort()
    return [all, listOpts]

def GtkTvFilter(ts, fnVisible,fnSEntry_chg,placeHolder,p=None,tT=None):
    tsFilter =ts.filter_new()
    tsFilter.set_visible_func(fnVisible, None) 
    sEntry = Gtk_(Gtk.SearchEntry(),p=p,cnn={"changed": fnSEntry_chg}, fill=0, tt=tT)
    sEntry.placeholder_text=placeHolder
    tsFilter.refilter()
    return tsFilter

def getSel(widget):
    selection = widget.get_selection()
    return selection.get_selected()

def GtkW(tit, W, H, onTop=True):
    w = Gtk.Window()
    w.set_title(tit)
    w.set_default_size(W, H)
    if onTop:
        showOnTop(w)
    return w

class GtkTreeV(Gtk.TreeView):
    def __init__(self, model, cols, props=None, parent=None, show=1, cnn=None, f=0, tt="", tm="", rowAct=None, btnPress=None):
        super().__init__()
        self.set_model(model)
        for i in range(0, len(cols)):
            if cols[i]!="":
                tvCol(self, cols[i], i)
        self.set_reorderable(False)
        self.set_search_column(0)
        tv_sel = self.get_selection()
        tv_sel.set_mode(Gtk.SelectionMode.SINGLE)
        self.set_grid_lines(Gtk.TreeViewGridLines.HORIZONTAL)
        if rowAct:
            self.connect("row-activated", rowAct)
        if btnPress:
            self.connect("button-press-event", btnPress)
        Gtk_(self, props=props, p=parent, show=show, cnn=cnn, fill=f, tt=tt, tm=tm)

    def cols(self, i=None):
        cols=self.get_columns()
        if i != None:
            return cols[i]
        else:
            return cols

    def colPixbuf(self, colIndex, tit="", xpad=10, ypad=5):
        pb=Gtk.CellRendererPixbuf()
        pb.set_property("xpad", xpad)
        pb.set_property("ypad", ypad)
        col_ico = Gtk.TreeViewColumn(tit, pb, pixbuf=colIndex)
        self.append_column(col_ico)
        col_ico.set_sizing(Gtk.TreeViewColumnSizing.AUTOSIZE)
        col_ico.set_resizable(False)
        col_ico.set_expand(False)

    def cell(self, col):
        sel = self.sel()
        (model, iter) = sel.get_selected()
        return model.get_value(iter, col)

    def sel(self, i=""):
        sel = self.get_selection()
        if i=="":
            return sel
        else:
            sel.select_path(i)
