import gi
gi.require_version('Gimp', '3.0')
gi.require_version('GimpUi', '3.0')
gi.require_version('Gtk', '3.0')

from gi.repository import Gtk, Gdk, GdkPixbuf
from gtkutils import *
import gettext, os, sys

DOMAIN = "python-console-2"
LOCALE_DIR = os.path.join(os.path.dirname(__file__), 'locale')
gettext.bindtextdomain(DOMAIN, LOCALE_DIR)
gettext.textdomain(DOMAIN)
_ = gettext.gettext

class IconsViewer(Gtk.Dialog):
    def findIcons(self):
        tsI = Gtk.ListStore(str, GdkPixbuf.Pixbuf)
        all=self.findAll.get_active()
        symb=self.onlySymbolic.get_active()
        if all:
            for n in self.allIcons:
                if self.searchIco in n:
                    if symb and not "-symbolic" in n:
                        continue
                    tsI.append([n, get_icon_pixbuf(n, 48)])
        else:
            for n in self.allIcons:
                if n.find(self.grp)==0:
                    part = n[n.find("-"):]
                    if self.searchIco in part:
                        if symb and not "-symbolic" in part:
                            continue
                        tsI.append([n, get_icon_pixbuf(n, 48)])
        self.tvIcons.cols(0).set_title(_("%d icons found") % (len(tsI)))
        self.tvIcons.set_model(tsI)
        self.tvIcons.sel("0")

    def iconsShow(self, path_info, tree):
        model = tree.get_model()
        iter = model.get_iter(path_info)
        if iter is not None:
            valor = model[iter][0] + "-"
            self.grp=valor
            self.findIcons()

    def findIco_chg(self, entry):
        self.searchIco = entry.get_text().lower()
        self.findIcons()

    def on_grp_icon_chng(self, treeview, path, column):
        self.iconsShow(path, treeview)
        return True

    def grpIconClk(self, widget, event):
        if event.type == Gdk.EventType.BUTTON_PRESS and event.button == 1:
            path_info = widget.get_path_at_pos(int(event.x), int(event.y))
            if path_info is not None:
                path, col, cell_x, cell_y = path_info
                self.iconsShow(path, widget)
            return True
        return False

    def fltrGrpIcos(self, model, iter, data):
        IcoGrpName = model.get_value(iter, 0).lower()
        search = self.searchIcoGrp
        if not search: return True
        if search in IcoGrpName: return True
        return False

    def findGrpIco_chg(self, entry):
        self.searchIcoGrp = entry.get_text().lower()
        self.tsGrpFltr.refilter()

    def _chck_symbolic (self, check_btn):
        self.findIcons()

    def __init__(self, parent=None, title=_("Icons viewer")):
        super().__init__(title=title, transient_for=parent, modal=True, destroy_with_parent=True)
        self.add_buttons(Gtk.STOCK_CANCEL, Gtk.ResponseType.CANCEL, Gtk.STOCK_OK, Gtk.ResponseType.OK)
        self.set_default_size(650, 500)
        self.set_border_width(1)
        showOnTop(self)
        button = self.get_widget_for_response(Gtk.ResponseType.OK)
        button.set_label(_("Insert in Console"))  # New text
        self.grp=""

        box = self.get_content_area()
        all, listOpts=listIcons()
        self.allIcons = all

        hpaned = Gtk_(Gtk.HPaned(),{"position":175,"wide-handle":True})
        box.pack_start(hpaned, expand=True, fill=True, padding=3)
        cnt1 = Gtk.VBox()
        hpaned.pack1(cnt1, True, True)
        cnt2 = Gtk.VBox()
        hpaned.pack2(cnt2, True, True)

        self.searchIcoGrp=""
        self.searchIco=""
        swin1 = scrollW(props = {"margin":1}, p = cnt1)
        tsGrIcons = Gtk.TreeStore(str)
        for n in listOpts:
            tsGrIcons.append(None,[n])
        self.tsGrpFltr = GtkTvFilter(tsGrIcons, self.fltrGrpIcos,self.findGrpIco_chg, _("Filter"),p=cnt1, tT=_("Only prefixes containing this text"))
        self.tvGrIcons = GtkTreeV(self.tsGrpFltr, [_('Prefix')], btnPress=self.grpIconClk, rowAct = self.on_grp_icon_chng)
        swin1.add(self.tvGrIcons)
        self.tvGrIcons.set_size_request(170, 450)
        # ------------------------------------------------
        swin = scrollW(props = {"margin":1},p=cnt2)
        tsIcons = Gtk.ListStore(str, GdkPixbuf.Pixbuf)
        sEntry = Gtk_(Gtk.SearchEntry(),p=cnt2,cnn={"changed": self.findIco_chg}, fill=0, tt=_("Only icons containing this text"))
        sEntry.set_placeholder_text(_("Only icons containing this text"))

        self.tvIcons = GtkTreeV(tsIcons, [_('Name')], cnn = {})
        self.tvIcons.colPixbuf(1)
        swin.add(self.tvIcons)
        self.onlySymbolic=GTKCbLab(_("Only show Symbolic"), toggled= self._chck_symbolic, p = cnt2)
        self.findAll=GTKCbLab(_("Search in all icons"), toggled= self._chck_symbolic ,p = cnt2)
        self.show_all()

    def run_and_get_text(self):
        response = self.run()
        text = None
        if response == Gtk.ResponseType.OK:
            text = self.tvIcons.cell(0)
        self.destroy()
        return text