import gi
gi.require_version('Gimp', '3.0')
gi.require_version('GimpUi', '3.0')
gi.require_version('Gtk', '3.0')

from gi.repository import Gtk, Gdk, GdkPixbuf
from gtkutils import *
import gettext, os, sys

DOMAIN = "python-console-2"
LOCALE_DIR = os.path.join(os.path.dirname(__file__), 'locale')
gettext.bindtextdomain(DOMAIN, LOCALE_DIR)
gettext.textdomain(DOMAIN)
_ = gettext.gettext

from gimpshelf import *

thisPth = os.path.dirname(sys.argv[0]) + os.sep
shelf=GimpShelf(thisPth+"snippets" + os.sep + "snippets.json")

class SnippetNew(Gtk.Dialog):
    def newSnippet(self):
        grp=self.cmbGroup
        newGrp=False
        gname = self.newGrpName.get_text()
        model = grp.get_model()
        iter = grp.get_active_iter()
        if iter is not None:
            valor = model[iter][1]
            if valor!=-1:
                gname=model[iter][0]
            else:
                newGrp=True
        tit = self.snipTit.get_text()
        code=TextViewGetAll(self.newSnpCode)
        if gname!="":
            snippet_add(shelf, gname, tit, code)
            return (True, newGrp)

    def on_grp_changed(self, combo):
        model = combo.get_model()
        iter = combo.get_active_iter()
        if iter is not None:
            valor = model[iter][1]
            self.hboxNewGrp.set_visible(valor==-1)


    def snpGrps(self):
        grps=[(k['t'],i) for i, (k) in enumerate(shelf.read_all())]
        grps.append([_("+ New group"),-1])
        return grps

    def __init__(self, parent=None, title=_("Add new snippet")):
        super().__init__(title=title, transient_for=parent, modal=True, destroy_with_parent=True)
        self.add_buttons(Gtk.STOCK_CANCEL, Gtk.ResponseType.CANCEL, Gtk.STOCK_OK, Gtk.ResponseType.OK)
        self.set_default_size(650, 500)
        self.set_border_width(1)
        showOnTop(self)
        button = self.get_widget_for_response(Gtk.ResponseType.OK)
        button.set_label(_("Add new Snippet"))  # New text
        self.grp=""
        box = self.get_content_area()
        self.snipTit=lbEntry(box, _("Snippet title"), GtkTx(""))
        GtkLb(_('Code:'),{}, p=box,f=0)
        swin = scrollW(props = {"margin":5})
        box.pack_start(swin, expand=True, fill=True, padding=3)
        self.newSnpCode=Gtk_(Gtk.TextView(),{},p = swin, fill=1)
        self.hboxNewGrp=Gtk_(Gtk.HBox(),{"margin" : 5}, fill=0)
        self.cmbGroup = GtkCbox(Gtk.ListStore(str, int), self.snpGrps(), cnn={"changed": self.on_grp_changed})
        lbEntry(box, _("Add to group"), self.cmbGroup)
        box.pack_start(self.hboxNewGrp, expand=False, fill=False, padding=3)
        GtkLb(_("Group name")+":", p=self.hboxNewGrp, f=0)
        self.newGrpName = GtkTx("", p = self.hboxNewGrp)

    def run_and_get_text(self):
        response = self.run()
        text, newGrp = (None, None)
        if response == Gtk.ResponseType.OK:
            (text, newGrp) = self.newSnippet()
        self.destroy()
        return (text, newGrp)