#!/usr/bin/env python
# -*- coding: utf-8 -*-
from gi.repository import Gimp
import gi
gi.require_version('Gimp', '3.0')

import math #, gimpplugin
#from gimpenums import *
pdb = Gimp.get_pdb()

import pnt2d
from pnt2d import *

EPSILON = 0.000001
varBez = 0.551915024494

def pnts2bezs(arrpnts):
	return [bezpnt(p) for p in arrpnts]

def hipot(catA,catB):
	return math.sqrt(catA*catA + catB*catB)

def polyRounded(rad,rot,sides,rad2,inscribed=True):
	bezs=[]
	rrot=math.radians(rot)
	pC=pnt2d(0,rad)
	if rad2 == 0.0 :
		for n in range(int(sides)):
			bezs.append(bezpnt([pC.x,pC.y]))
			pC.rotate(rrot)
	else:
		if inscribed:
			bez = arcLinesBez(pC,pnt2d(0,rad).rotate(rrot),pnt2d(0,rad).rotate(-rrot),rad2)
		else:
			rrot=math.radians(360/sides)
			rot=(360/sides)
			r1=rot * 0.5
			bez=createArcBez(rad2, math.radians(r1+90), math.radians(-r1+90))
			bez=[b.translate(0,rad-rad2) for b in bez]
		for rr in range(int(sides)): bezs.extend(rotArcBez(bez,-rot*rr))
	return bezs

def lineaTrazos(P1,p2,l):
	lx = p2[0]-P1[0]
	ly = p2[1]-P1[1]
	len = hipot(lx,ly)
	prop = l / len
	tot=len / (l * 2.0)
	p1x=lx / tot
	p1z=ly / tot
	pnts=[]
	for i in range(int(math.ceil(tot/2.0))):
		pnts.append([bezpnt([P1[0]+p1x*(i*2),P1[1]+p1z*(i*2)]),bezpnt([P1[0]+p1x*(i*2+1),P1[1]+p1z*(i*2+1)])])
	return pnts

def polySideLen(radius,sides):
	return 2.0 * radius * math.sin(math.radians(180.0/sides))

def pntAtDist(p1,p2,dist):
	p3= pnt2d(p2.x - p1.x,p2.y - p1.y)
	length = p3.length()
	p4=pnt2d(p3.x/length,p3.y/length)
	p4.scale(dist,dist)
	return pnt2d(p1.x+p4.x, p1.y+p4.y)

def angBetween2Lines(pC,p1,p2): # pC punto comun
	return math.atan2(pC.y-p1.y, pC.x-p1.x) - math.atan2(pC.y-p2.y, pC.x-p2.x)

def createSmallArcBez(r, a1, a2):
	a = (a2 - a1) * 0.5
	p4 = pnt2d(r * math.cos(a), r * math.sin(a))
	p1 = pnt2d(p4.x, -p4.y)
	k = 0.5522847498
	f = k * math.tan(a)
	p2 = pnt2d(p1.x + f * p4.y, p1.y + f * p4.x)
	p3 = pnt2d(p2.x,-p2.y) 
	ar = a + a1
	P1 = pnt2d(r * math.cos(a1), r * math.sin(a1)) 
	P2 = pnt2d(p2.x, p2.y).rotate(ar)
	P3 = pnt2d(p3.x, p3.y).rotate(ar)
	P4 = pnt2d(r * math.cos(a2),r * math.sin(a2))
	B1=bezpnt(P1,None,P2)
	B2=bezpnt(P4,P3)
	return [B1,B2]

def centerBezs(bezs,x1,y1,an,al):
	for bez in bezs: bez.translate(x1+an * 0.5, y1+al * 0.5)
	return bezs

def createArcBez(rad, sAng, eAng, posY=0.0):
	bezs =[]
	pi2 = math.pi * 2
	sAng,eAng = (sAng % pi2, eAng % pi2)
	piOver2 = math.pi * 0.5
	sign = 1 if (sAng < eAng) else -1
	a1 = sAng
	totAng = min(math.pi * 2, abs(eAng - sAng))
	while (totAng > EPSILON):
		a2 = a1 + sign * min(totAng, piOver2)
		bezs.extend(createSmallArcBez(rad, a1, a2))
		totAng = totAng - abs(a2 - a1)
		a1 = a2
	return bezs

def rotArcBez(bezs,ang):
	pts2=[]
	rrr = math.radians(ang)
	for bez in bezs:
		bp=bezpnt().copy(bez).rotate(rrr)
		pts2.extend([bp])
	return pts2

def arcLinesBez(pC,P1,P2,rad):
	tBezs = []
	Rot = angBetween2Lines(pC,P1,P2)
	hipo=rad/math.sin(Rot * 0.5)
	catB=rad/math.tan(Rot * 0.5)
	bz1 = pntAtDist(pC,P1,catB)
	bx1 = pntAtDist(pC,P2,catB)
	pC2 = pnt2d(0,-hipo+pC.y)
	Rot2 = angBetween2Lines(pC2,bx1,bz1)
	iniRot=(math.pi-Rot2) * 0.5
	tBezs = createArcBez(rad, iniRot, Rot2+iniRot)
	for bez in tBezs:
		bez.translate(0.0,pC.y-abs(hipo))
	return tBezs

def starRoundBez(rad,radInt,rot,sides,rad2):
	bezs=[]
	rrot=math.radians(rot)
	pC, pC2=(pnt2d(0,rad), pnt2d(0,radInt))
	if rad2 == 0.0 :
		pC2.rotate(rrot)
		for n in range(int(sides * 0.5)):
			bezs.extend([bezpnt([pC.x,pC.y]),bezpnt([pC2.x,pC2.y])])
			pC.rotate(rrot*2)
			pC2.rotate(rrot*2)
	else:
		pts = arcLinesBez(pC,pnt2d(0,radInt).rotate(rrot),pnt2d(0,radInt).rotate(-rrot),rad2)
		pC2.rotate(-rrot)
		for rr in range(int(sides)):
			if rr % 2 == 0:
				bezs.extend(rotArcBez(pts,-rot*rr))
			else:
				bezs.append(bezpnt(pnt2d(pC2.x,pC2.y)))
				pC2.rotate(-rrot*2)
	return bezs

def bezCross(x,y,size):
	bezs=[]
	bezs.extend([bezpnt([x,y-size]),bezpnt([x,y+size])])
	bezs.extend([bezpnt([x-size,y]),bezpnt([x+size,y])])
	return bezs

class dims():
	w, h = (0.0, 0.0)
	img = None
	t, r, b, l = (0.0, 0.0, 0.0, 0.0)
	sw, sh, cx, cy= (0.0, 0.0, 0.0, 0.0)
	def squared(self, sq=False):
		if sq:
			lado = math.min(self.sw, self.sh)
			if lado != an:
				self.l = self.l + (self.sw-lado) * 0.5
				self.r = self.l + lado # x2-(an-lado) * 0.5
			if lado != al:
				self.t = self.t + (self.sh-lado) * 0.5
				self.b = self.t - lado

	def incr(self, val):
		self.l -= val
		self.t -= val
		self.r += val
		self.b += val

	def asign(self):
		self.w = self.img.get_width()
		self.h = self.img.get_height()

		#(True, non_empty=True, x1=599, y1=216, x2=848, y2=848)
		No, non_empty, self.l, self.t, self.r, self.b = Gimp.Selection.bounds(self.img)
		if non_empty==False: self.l, self.t, self.r, self.b=( 0, 0, self.w, self.h)
		self.sw = self.r - self.l
		self.sh = self.b - self.t
		self.cx = self.l + self.sw * 0.5
		self.cy = self.t + self.sh * 0.5

	def __init__(self, img):
		self.img = img
		self.asign()
