from gi.repository import Gimp, GObject, GLib
import gi

gi.require_version('Gtk', '3.0')
gi.require_version('Gimp', '3.0')

class GImg:
    def __init__(self, image: Gimp.Image):
        if not isinstance(image, Gimp.Image):
            raise TypeError(
                "El argumento 'image' debe ser una instancia de Gimp.Image.")
        self._i = image
        print(f"Manejador de imagen inicializado para '{self._i.get_name()}'.")

    def _w(self) -> int:
        return self._i.get_width()

    def _h(self) -> int:
        return self._i.get_height()

    def _layer(self, name: str, w: int = None, h: int = None,
               type: Gimp.ImageType = Gimp.ImageType.RGB_IMAGE,
               opacity: float = 100.0, mode: Gimp.LayerMode = Gimp.LayerMode.NORMAL) -> Gimp.Layer:
        if w is None:
            w = self._w()
        if h is None:
            h = self._h()
        try:
            # Gimp.Layer.new(image, name, width, height, type, opacity, mode)
            new_layer = Gimp.Layer.new(self._i, name, w, h, type, opacity, mode)
            # Insertar la capa en la imagen. El -1 indica añadir al final de la pila.
            self._i.insert_layer(new_layer, None, -1)
            print(f"Capa '{name}' ({w}x{h}) añadida exitosamente.")
            return new_layer
        except GObject.GError as e:
            Gimp.message(f"Error al añadir la capa '{name}': {e}")
            raise

    def _path(self, name: str, segments: list[Gimp.VectorsAnchor], closed: bool = True) -> Gimp.Vectors:
        if not segments:
            raise ValueError("La lista de segmentos no puede estar vacía para crear una ruta.")
        try:
            new_vectors = Gimp.Vectors.new(self._i, name)
            # Crear un "stroke" (trazo) a partir de los segmentos
            # Gimp.VectorsStroke.new_from_bezier() es el constructor clave aquí.
            stroke = Gimp.VectorsStroke.new_from_bezier(
                new_vectors, segments, closed)
            new_vectors.add_stroke(stroke)
            self._image.insert_vectors(new_vectors, 0)
            print(f"Ruta '{name}' añadida exitosamente.")
            return new_vectors
        except GObject.GError as e:
            Gimp.message(f"Error al añadir la ruta '{name}': {e}")
            raise

    def get_i(self) -> Gimp.Image:
        return self._i
