"""
import importlib

def import_mod(name_mod):
    try:
        modulo = importlib.import_module(name_mod)
        print(f"Módulo '{name_mod}' importado exitosamente.")
        return modulo
    except Exception as e:
        print(f"Ocurrió un error inesperado al importar '{name_mod}': {e}")
        return None

import os
for module in os.listdir(os.path.dirname(__file__)):
    if module == '__init__.py' or module[-3:] != '.py':
        continue
    print(module[:-3])
    #import_mod(module[:-3])
    import_mod(module)
	#__import__(module[:-3], locals(), globals())
#del module
"""

import os, sys, importlib

dir_plugins = os.path.dirname(os.path.abspath(__file__))

cargados = {}
if dir_plugins not in sys.path:
	sys.path.insert(0, dir_plugins)

nom_base = os.path.basename(dir_plugins)

for nom in os.listdir(dir_plugins):
	if nom.endswith(".py") and nom != "__init__.py":
		nom_modulo = nom[:-3]
		es_paquete = os.path.exists(os.path.join(dir_plugins, '__init__.py'))

		if es_paquete:
			nom_import = f"{nom_base}.{nom_modulo}"
		else:
			nom_import = nom_modulo
		try:
			modulo = importlib.import_module(nom_import)
			cargados[nom_modulo] = modulo
		except Exception as e:
			print(f"  -> ERROR al cargar '{nom_import}': {e}")
