from __main__ import *

def bezsEllipse(x1,x2,y1,y2):
	an, al=(x2 - x1, y2 - y1)
	an2, al2=(an/2, al/2)
	xBez, yBez=(varBez*an2, varBez*al2)
	bezs=[bezpnt([x1,y1+al2],[x1,y1+al2-yBez],[x1,y1+al2+yBez]),bezpnt([x1+an2,y2],[x1+an2-xBez,y2],
		[x1+an2+xBez,y2]),bezpnt([x2,y1+al2],[x2,y1+al2+yBez],[x2,y1+al2-yBez]),bezpnt([x1+an2,y1],
		[x1+an2+xBez,y1],[x1+an2-xBez,y1])]
	return bezs

def shapeEllipse(x1,x2,y1,y2,objs):
	bezs=bezsEllipse(x1,x2,y1,y2)
	hr=' - '+_('Horizontal')+": "+str((x2-x1)*0.5)+'px\n'
	hv=' - '+_('Vertical')+": "+str((y2-y1)*0.5)+'px'
	return [_("ellipse"),bezs,_('Radius')+':\n'+hr+hv,'',True]

def bezsArc(x1,x2,y1,y2, rot1, rot2, close):
	an, al=(x2 - x1, y2 - y1)
	an2, al2=(an/2,al/2)
	la = min(an,al)
	bezs=createArcBez(la/2, math.radians(rot1),math.radians(rot2))
	if close==1:bezs.append(bezpnt([0,0]))
	return centerBezs(bezs,x1,y1,an,al)

def shapeArc(x1,x2,y1,y2, objs):
	v1,v2=(getVal(objs[0]),getVal(objs[1]))
	v6=getRadioIndex(objs[2])
	an, al=(x2 - x1, y2 - y1)
	an2, al2=(an/2,al/2)
	la = min(an,al)/2.0
	name=_('arc')+str(int(v1))+'_'+str(int(v2))
	bezs=createArcBez(la, math.radians(v1),math.radians(v2))
	if v6==1:bezs.append(bezpnt([0,0]))
	closed=v6>0
	bezs=centerBezs(bezs,x1,y1,an,al)
	msg=_('Radius')+': '+str(la)+'px'
	return [name,bezs,'',msg,closed]

SHAPES2['ellip']={'tit':_('Ellipse'),'def2':shapeEllipse,'objs':[],'grp':_('Circular')}

SHAPES2['arc']={'tit':_('Arc'),'def2':shapeArc,
	'objs':[
		{'t':'tit','label':_("Angles")+':'},
		{'t':'float','adj':[ 0.0,-360.0,360.0,0.2],'digits':2,'label':_("Start")+':'},
		{'t':'float','adj':[90.0,-360.0,360.0,0.2],'digits':2,'label':_("End")+':'},
		{'label':_("Closed")+':'       ,'t':'radio','vals':ArcSEL, 'dir':'h'}
	],'grp':_('Circular')
}
