from __main__ import *

def computeDpt(r1, r2, theta):
	return math.sqrt(math.pow(r1 * math.sin(theta), 2) + math.pow(r2 * math.cos(theta), 2))

def elliVerts(r1,r2,n):
	deltaTheta = 0.001
	numIntegrals = math.floor(math.pi * 2.0 / deltaTheta)
	circ, dpt, theta, i=(0.0, 0.0, 0.0, 0)
	while (i<numIntegrals):
		theta += i*deltaTheta
		dpt = computeDpt( r1, r2, theta)
		circ += dpt
		i += 1
	nextPoint,run,theta, i = (0, 0.0, 0.0,0)
	pnts=[]
	while(i < numIntegrals):
		theta += deltaTheta
		subIntegral = n * run / circ
		if (int(subIntegral) >= nextPoint):
			pnts.append([r1 * math.cos(theta),r2 * math.sin(theta)])
			nextPoint += 1
		run += computeDpt(r1, r2, theta)
		i += 1
	return pnts

def angBetween2pts(P1,P2):
	rot = math.degrees(math.atan2(P2[0] - P1[0], P2[1] - P1[1]))
	if rot<0: rot = rot + 360.0
	return rot

def lineLen(P1,P2):
	return math.sqrt(math.pow(P2[0] - P1[0],2)+math.pow(P2[1] - P1[1],2))

def halfCirc(x1,x2,y1,y2):
	an, al=(x2 - x1, y2 - y1)
	an2, al2=(an*0.5, al*0.5)
	xBez, yBez=(varBez*an2, varBez*al2)

	bezs=[bezpnt([x2,y1+al2],None,[x2,y1+al2+yBez]),
		bezpnt([x1+an2,y2],[x1+an2+xBez,y2],[x1+an2-xBez,y2]),
		bezpnt([x1,y1+al2],[x1,y1+al2+yBez])]
	return bezs

def shapeCloud(x1,x2,y1,y2, objs):
	an=(x2-x1) * 0.5
	al=(y2-y1) * 0.5
	v3=int(getVal(objs[0]))
	bezs=[]
	msgTit=""
	msg=""
	pts=elliVerts(an,al,v3)
	old=None
	for n in range(v3):
		a = pts[n]
		b = pts[n+1] if n<len(pts)-1 else pts[0]
		radio = lineLen(a,b) * 0.5
		rot = angBetween2pts(a,b)
		bz=halfCirc(0,radio * 2.0,-radio,radio)
		Angle = math.degrees(math.atan2(a[1]-b[1], a[0]-b[0]))
		if (Angle < 0): Angle += 360.0
		for nn in bz: nn.rotate(math.radians(Angle)).translate(b[0] + x1 + an,b[1] + y1 + al)
		if old: bz[0].fixed = old
		old=bz[2].fixed
		bezs.extend(bz)
	bezs[0].fixed = old
	return [_("Cloud")+str(v3),bezs,msgTit,msg,True]

SHAPES2['think']={
	'tit' :_('Cloud'),
	'def2':shapeCloud,
	'objs':[{'label':_("Parts")+':' ,'t':'float','adj':[5,3,200,1],'digits':0}],'grp':_('Circular')
}
