from __main__ import *

def polyStar2(x1,x2,y1,y2, objs,tipo='p'):
	an, al=(x2 - x1, y2 - y1)
	la = min(al,an)
	bezs=[]
	try:
		pnts = int(getVal(objs[0]))
		name=_('Polygon') if tipo=='p' else _('Star')
		name = name + str(pnts)
		v1 = getVal(objs[1])
		if tipo=='s':
			v5 = getVal(objs[2])
			if v5==0.0: v5=0.1
			starr2=100.0 / v5
		if tipo == 's': pnts = pnts * 2
		rot=360.0/pnts
		rd=la * 0.5
		if tipo=='p':
			corners=objs[2]['obj'].get_active()
			mrad = la / 2.0 * math.cos(math.radians(180.0 / pnts))
			bezs = polyRounded(rd,rot,pnts,v1,corners==0)
		else:
			mrad=(2.0*rd/starr2)*math.sin(math.pi/pnts)
			bezs = starRoundBez(rd,rd/starr2,rot,pnts,v1)
	except Exception as e:
		debugErr(e)
	bezs=centerBezs(bezs,x1,y1,an,al)
	return [name+str(pnts),bezs,_('Max. roundness')+':',mrad,True]

def shapePoly2(x1,x2,y1,y2, obj):
	n,bezs,a,b,c = polyStar2(x1,x2,y1,y2, obj,'p')
	return [n,bezs,a,b,c]

def shapeStar2(x1,x2,y1,y2, obj):
	return polyStar2(x1,x2,y1,y2, obj,'s')

SHAPES2['polygon']={'tit':_('Polygon'),'def2':shapePoly2,
	'objs':[
		{'label':_("Sides")+':'       ,'t':'float','adj':[5,3,200,1],'digits':0},
		{'label':_("Roundness")+':'   ,'t':'float','adj':[0.2,0.0,200.0,0.2],'digits':2},
		{'label':_("Inscribed in")+':','t':'combo','vals':POLYSEL}
	],'grp':_('Circular')
}

SHAPES2['star']={'tit':_('Star'),'def2':shapeStar2,
	'objs':[
		{'label':_("Points")+':' ,'t':'float','adj':[5,3,200,1],'digits':0},
		{'label':_("Roundness")+':' ,'t':'float','adj':[2.0,0.0,200.0,0.2],'digits':2},
		{'label':sIntRadius ,'t':'float','adj':[50.0,2.0,200.0,0.2],'digits':2}
	],'grp':_('Circular')
}
