from __main__ import *

def shapeRomb2(x1,x2,y1,y2, objs):
	rad,Type=getVals(objs)
	corners=Type
	name=_('rhomboid')
	an, al=(x2 - x1, y2 - y1)
	an2, al2=(an * 0.5,al * 0.5)
	la = min(an,al)
	rad2 = rad * 0.5
	ll=math.sqrt(an2 * an2 + al2 * al2)*4
	mrad=(an*al)/ll
	if rad==0:
		bezs=[bezpnt(p) for p in [[x1+an2,y1], [x1,y1+al2], [x1+an2,y2], [x2,y1+al2]]]
	# chamfer
	else:
		if corners==1:
			name+=_('Chamfer')
			bezs=[bezpnt(p) for p in [[x1+an2-rad2,y1],[x1+an2+rad2,y1],[x2,y1+al2-rad2],[x2,y1+al2+rad2],[x1+an2+rad2,y2],[x1+an2-rad2,y2],[x1,y1+al2+rad2],[x1,y1+al2-rad2]]]
		elif corners==0:
			name+=_('Rounded')
			bezs=[]
			arc1=arcLinesBez(pnt2d(0,an2),pnt2d(-al2,0),pnt2d(al2,0),rad)
			arc2=arcLinesBez(pnt2d(0,al2),pnt2d(-an2,0),pnt2d(an2,0),rad)
			bezs.extend(rotArcBez(arc1,90)+rotArcBez(arc2,0)+rotArcBez(arc1,270)+rotArcBez(arc2,180))
			for bez in bezs: bez.translate(x1+an/2.0, y1+al/2.0)
	return [name,bezs,_('Max. roundness:'),mrad,True]

SHAPES2['romb']={'tit':_('Rhombus'),
	'def2':shapeRomb2,
	'objs':[
		{'label':_("Roundness")+':','t':'float','adj':[0.0,0.0,400.0,0.2],'digits':2},
		{'label':_("Type")+':'     ,'t':'radio','vals':CORNERSROMB}
	],'grp':_('Others')
}
