#!/usr/bin/env python
# -*- coding: utf-8 -*-
from gi.repository import Gimp
from gi.repository import Gtk
import gi
gi.require_version('Gtk', '3.0')
gi.require_version('Gimp', '3.0')

import traceback

def dbg(aaa):
    print(str(aaa))

def defIndex(arr, index, alt=None):
    if len(arr) > index:
        return arr[index]
    else:
        return alt

def detError(e):
    print(f"Error: {e}")
    print(traceback.format_exc())

class drawUi(object):
    def __init__(self):
        pass

    def addProps(self, obj, props):
        for Key, Value in props:
            obj.set_property(Key, Value)
            
    #def addLabel(self, tx, alignx=1.0, aligny=0.5, tip=""):
    #    lb = Gtk.Label(label=tx)
    #    lb.set_alignment(alignx, aligny)
    #    if tip!="":
    #        lb.set_tooltip_text(tip)
    #    lb.show()
    #    return lb
    

    def rBtn(self, btn, lb):
        if btn==None:
            btn = Gtk.RadioButton(group=None, label=lb)
            btn.set_active(True)
        else:
            btn = Gtk.RadioButton(group=btn, label=lb)
        return btn

    def chBtn(self, tx, tip=""):
        lb = Gtk.CheckButton(label=tx)
        if tip!="":
            lb.set_tooltip_text(tip)
        lb.show()
        return lb

    def fillCombo(self, Store, combobox):
        st = combobox.get_model()
        st.clear()
        for n in Store:
            st.append(n)
        combobox.set_model(st)
        combobox.set_active(0)

    def makeCombo(self, Store):
        st = Gtk.ListStore(str, int)
        self.cmb = Gtk.ComboBox.new_with_model(st)
        cell = Gtk.CellRendererText()
        self.fillCombo(Store, self.cmb)
        self.cmb.pack_start(cell, True)
        self.cmb.add_attribute(cell, 'text', 0)
        self.cmb.set_active(0)
        return self.cmb

    def table(self, rows=1, columns=1, homogeneous=False, row_s=2, col_s=2):
        tab = Gtk.Table(rows, columns, homogeneous)
        tab.set_row_spacings(row_s)
        tab.set_col_spacings(col_s)
        tab.show()

    def getValues(self, arrFields):
        return (n.get_value() for n in arrFields)

    def getModelVal(self, widget):
        iter = widget.get_active_iter()
        model = widget.get_model()
        lP = model.get_value(iter, 1)
        return lP

    def _adj(self, val, low,upp, incre):
        return Gtk.Adjustment(value=val, lower=low, upper=upp, step_increment=incre)

    def spinBtn(self, adj, climb_rate=0.0, digits=0):
        return Gtk.SpinButton(adjustment=adj, climb_rate=climb_rate, digits=digits)

class Grid:
    row = 0
    _grid = None

    def __init__(self, parent=None):
        grid = Gtk.Grid()
        grid.set_row_spacing(5)
        grid.set_column_spacing(5)
        grid.set_margin_start(5)
        grid.set_margin_end(5)
        grid.set_margin_top(10)
        grid.set_margin_bottom(10)
        if parent:
            #parent.pack_start(grid, False, False, 1)
            parent.add(grid)
        grid.show()
        self._grid = grid

    def clear(self):
        children = self._grid.get_children()
        for child in children:
            self._grid.remove(child)

    def setParent(self, parent):
        parent.pack_start(self._grid, False, False, 1)

    def incRow(self):
        self.row += 1
    
    def _row(self):
        return self.row

    def _cell(self, obj, col=0, colSpan=1, row=None, rowSpan=1, cnn='', fn=None, rowInc=None):
        # ToDo: Si row es none usar self.row y trabajar con incRow
        if row==None:
            row=self.row
        if type(obj) is str:
            obj = Gtk.Label(label=obj, xalign=0.0,)
        self._grid.attach(obj, col, row, colSpan, rowSpan)
        if cnn != '':
            obj.connect(cnn,fn)
        obj.show()
        if rowInc!=None:
            self.incRow()
        return obj
    
    def _cellLb(self,lb, obj, col=0, cSpan=1, row=None, rSpan=1, cnn='', fn=None, rowInc=None):
        self._cell(lb,  col=col, colSpan=cSpan, row=row, rowSpan=rSpan)
        self._cell(obj, col=col+1, colSpan=cSpan, row=row, rowSpan=rSpan, cnn=cnn, fn=fn)
        if rowInc!=None:
            self.incRow()
        obj.show()
        return obj

    def _btn(self, label, col=0, colSpan=1, row=0, rowSpan=1, cnn='', fn=None):
        obj=Gtk.Button(label=label)
        return self._cell(obj, col, colSpan, row, rowSpan, cnn, fn)

def pdbCall(func, props):
    pdb=Gimp.get_pdb()
    proc = pdb.lookup_procedure(func)
    cfg = proc.create_config()
    for n in props:
        cfg.set_property(n, props[n]);
    return proc.run(cfg)

