import os, json

class GimpShelf:
    def __init__(self, file_path, encoding='utf-8'):
        self.file_path = file_path
        self.encoding = encoding

    def file_exists(self):
        return os.path.isfile(self.file_path)
    
    def read_all(self):
        if not self.file_exists():
            return None
        try:
            with open(self.file_path, 'r', encoding=self.encoding) as f:
                content = f.read()
                return json.loads(content)
        except Exception:
            return {}

    def write(self, content, mode='w'):
        if mode not in ['w', 'a']:
            return False
        try:
            dir_name = os.path.dirname(self.file_path)
            if dir_name and not os.path.exists(dir_name):
                os.makedirs(dir_name)
            with open(self.file_path, mode, encoding=self.encoding) as f:
                f.write(json.dumps(content))
                return True
        except Exception:
            return False