#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#    This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <https://www.gnu.org/licenses/>.

import os, sys, gettext
import drawUI
from gi.repository import Gtk,Gdk, GLib, GimpUi, Gimp
import gi
gi.require_version('Gimp', '3.0')
gi.require_version('GimpUi', '3.0')
gi.require_version('Gegl', '0.4')
gi.require_version('Gtk', '3.0')

import random
thisPth = os.path.dirname(sys.argv[0]) + os.sep

gettext.install("arakne-guides-lab", thisPth + 'locale')

fPath = os.path.join(os.path.dirname(__file__), "arakneshapes")
sys.path.append(fPath)

p = fPath + os.sep + 'locales'
shapesImgPath=fPath + os.sep + 'shapesImg'+ os.sep

sys.stderr = open(fPath + os.sep + "errors.txt",'a')
sys.stdout=sys.stderr

from pnt2d import *
from drawUI import *
try:
    from araknepathshapecreatorshapes import *
except Exception as e:
    print(e)

varBez = 0.551915024494
pathcreator_key='arakne-shape-creator'

def gVal(obj):
    if type(obj) is Gtk.SpinButton:
        n=obj
    else:
        n = obj['obj']
    if type(n) is list:
        return getRadioIndex(obj)
    elif type(n) is Gtk.SpinButton:
        v = n.get_value()
        if n.get_digits()==0: v=int(v)
        return v
    elif type(n) is Gtk.ComboBox: 
        return n.get_active()
    elif type(n) is Gtk.CheckButton: 
        return n.get_active()
    return None

def getVals(objs):
    vals=[]
    for a in objs:
        v = gVal(a)
        if v!=None:
            vals.append(v)
    return vals

def chAdj(obj, Min=None, Max=None):
	adj1=obj['obj'].get_adjustment()
	if Min!=None: adj1.set_lower(Min)
	if Max!=None: adj1.set_upper(Max)

def chVal(obj,val):
	obj['obj'].set_value(val)

def enableObj(obj,enabled = True, txLabel = None):
	obj['obj'].set_sensitive(enabled)
	obj['lb'].set_sensitive(enabled)

def debug(val):
	print(str(val))

def getRadioIndex(radios):
    index=0
    n=0
    radios=radios['obj']
    for r in radios:
        if r.get_active():#revisar
            index=n
        n+=1
    return index

def getVal(o):
	return o['obj'].get_value()

CORNERS=[[_('Rounded'),0],[_('Rounded inverse'),1],[_('Chamfer'),2]]
CORNERSROMB=[[_('Rounded'),0],[_('Chamfer'),1]]
POLYSEL=[[_('Polygon'),0],[_('Circle'),1]]
ArrowSEL=[[_('Top'),0],[_('Bottom'),1],[_('Left'),2],[_('Right'),3]]
ArcSEL=[[_('Open'),0],[_('At center'),1],[_('Linear'),2]]
# selection modes:
oppSel=[[_("Add to current"),0],[_("Substract"),1],[_("Replace current"),2],[_("Intersect"),3]]
oppFill=[[_("Don't fill"),0],[_("With foreground"),1],[_("With background"),2],[_("With pattern"),3]]

oppStro=[["Don't stroke",0],["Stroke path",1],["Stroke over fill",2]]
sIntRadius=_("Interior radius")+' %:'

def shapeRectangle(x1,x2,y1,y2, v1,v6):
	name=_('rect')
	bezs=[bezpnt(nn) for nn in [[x1,y1], [x1,y2], [x2,y2], [x2,y1]]]
	an, al=(x2 - x1, y2 - y1)
	rad=v1
	if rad>0:
		corners = v6
		if corners==1:
			name+=_('RoundedInv')
			r2 = rad * varBez
			fpts2=[[x1+r2,y1+rad], [x1+rad,y1+r2], [x2-rad,y1+r2], [x2-r2,y1+rad], [x2-r2,y2-rad], [x2-rad,y2-r2], [x1+rad,y2-r2], [x1+r2,y2-rad]]
		elif corners in [0,2]:
			name=name+_('chamfer') if corners==2 else name+_('rounded')
			r2=rad if corners==2 else rad*varBez
			fpts2=[[x1,y1+r2], [x1+r2,y1], [x2-r2,y1], [x2,y1+r2], [x2,y2-r2], [x2-r2,y2], [x1+r2,y2], [x1,y2-r2]]
		bezs=[
			bezpnt([x1,y1+rad],None,fpts2[0]), bezpnt([x1+rad,y1],fpts2[1]),
			bezpnt([x2-rad,y1],None,fpts2[2]), bezpnt([x2,y1+rad],fpts2[3]),
			bezpnt([x2,y2-rad],None,fpts2[4]), bezpnt([x2-rad,y2],fpts2[5]),
			bezpnt([x1+rad,y2],None,fpts2[6]), bezpnt([x1,y2-rad],fpts2[7])
		]
	return [name,bezs,_('Max. roundness')+':',min(al,an)*0.5,True]

def shapeRectangle2(x1,x2,y1,y2, objs):
	rad=getVal(objs[1])
	corners = getRadioIndex(objs[0])
	return shapeRectangle(x1, x2, y1, y2, rad, corners)

import collections

SHAPES2={
    'rect':{
        'tit':_('Rectangle'),
        'def2':shapeRectangle2,
        'objs':[
            {'label':_("Corners")+':','t':'radio','vals':CORNERS},
            {'label':_("Roundness")+':','t':'float','adj':[5.0,0.0,200.0,0.2],'digits':2}
        ],'grp':_('Rectangular')
    }
}

import shapes

SHAPES2 = collections.OrderedDict(sorted(SHAPES2.items(), key=lambda t: t[1]['tit']))

import json
from pathlib import Path
from gimpshelf import *

shelf=GimpShelf(fPath + os.sep + "shapes.json")

def centerBezs(bezs,x1,y1,an,al):
	for bez in bezs: bez.translate(x1+an * 0.5, y1+al * 0.5)
	return bezs

def debugErr(e):
    ex_type, ex_value, ex_traceback = sys.exc_info()
    # Extract unformatter stack traces as tuples
    trace_back = traceback.extract_tb(ex_traceback)
    # Format stacktrace
    stack_trace = list()
    for trace in trace_back:
        stack_trace.append("    File: %s\n    Line: %d\n    Func.Name: %s\n   Message: %s" % (trace[0], trace[1], trace[2], trace[3]))
    print("Exception type    : %s " % ex_type.__name__)
    print("Exception message : %s" % ex_value)
    print("Stack trace       : %s" % stack_trace)

    exc_type, exc_obj, exc_tb = sys.exc_info()
    fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
    debug(fname+'\n'+str(exc_tb.tb_lineno)+'\n'+str(e))

def setProps(obj,props):
	for n in props: obj.set_property(n,props[n])

def N_(message): return message

def Between(Num, Max):
    if Num < 0:
        return 0
    if Num > Max:
        return Max
    return Num

class ShapeCreator2025 (Gimp.PlugIn):
    Objs=[]
    pnts=[]
    pntsbak=[]
    prevClosed=False
    thispath=None
    name='cuad'
    change=True
    selBak=[]
    tabs=[]
    #tabTits=[_('Shape'),_('Selection'),_('Fill and border'),_('Transforms'),_('Shortcodes')]
    tabTits=[_('Shape'),_('Selection'),_('Fill and border'),_('Transforms')]

    # revisar
    img = None

    ui = drawUI.drawUi()

    grid = None #Gtk.Grid()

    def evalSpin(self, widget, data=None):
        s=widget.get_text().lower().replace('w',str(self._w())).replace('h',str(self._h()))
        widget.set_value(eval(s))

    def chDim(self, widget):
        este = widget.get_name()
        iLv,iRv,iWv,iHv,iTv,iBv=self.ui.getValues([self.iL,self.iR,self.iW,self.iH,self.iT,self.iB])
        self.change=False
        if este=='iW': self.iRFn=self.chSizeVal(self.iR,self.iRFn,iWv + iLv)
        if este=='iH': self.iBFn=self.chSizeVal(self.iB,self.iBFn,iHv + iTv)
        if este=='iR' or este=='iL': self.iWFn=self.chSizeVal(self.iW,self.iWFn,iRv + iLv)
        if este=='iT' or este=='iB': self.iHFn=self.chSizeVal(self.iH,self.iHFn,iBv + iTv)
        self.change=True
        self.chPath(widget)

    def saveToShelf(self):
        lP=self.getShape()
        saveVals=[]
        for n in self.Objs: saveVals.append(gVal(n))
        defvals=shelf.read_all()
        defvals['lastshape']=lP
        defvals[lP]=saveVals
        try:
            shelf.write(defvals)
        except Exception as e:
             print(e)

    def updselbtn(self, widget):
        ddd = dims(self.img)
        self.change=False
        self.iWFn=self.chSizeVal(self.iW, self.iWFn, ddd.sw)
        self.iHFn=self.chSizeVal(self.iH, self.iHFn, ddd.sh)
        self.iLFn=self.chSizeVal(self.iL, self.iLFn, ddd.l)
        self.iRFn=self.chSizeVal(self.iR, self.iRFn, ddd.r)
        self.iTFn=self.chSizeVal(self.iT, self.iTFn, ddd.t)
        self.iBFn=self.chSizeVal(self.iB, self.iBFn, ddd.b)
        self.change=True
        self.chPath(widget)
        return False

    def getShape(self):
        sel = self.tv.get_selection()
        model, iter = sel.get_selected()
        if iter==None:
            def find_and_select_leaf(parent_iter=None):
                nonlocal iter
                tree_iter = model.iter_children(parent_iter)
                while tree_iter is not None:
                    if not model.iter_has_child(tree_iter):
                        sel.select_iter(tree_iter)
                        path = model.get_path(tree_iter)
                        self.tv.expand_to_path(path)
                        iter=tree_iter
                        return True
                    if find_and_select_leaf(tree_iter):
                        return True
                    tree_iter = model.iter_next(tree_iter)
                return False

            if not find_and_select_leaf(None):
                pass
        return model.get_value(iter,1)

    def selAndFill(self, widget):
        drawable = self.img.get_selected_drawables()[0]
        flush = False
        stroke = self.selStroke.get_active()
        fill = self.fillFg.get_active()
        if stroke > 0 or fill > 0:
            self.img.undo_group_start()
            #if self.newLayer.get_active() == True:
            layer = Gimp.Layer.new(self.img,'layer_'+self.name, self._w(), self._h(), 1, 100, 0)
            self.img.insert_layer(layer, None, 0)
            drawable=layer
            channel = Gimp.Selection.save(self.img)
            Gimp.Selection.all(self.img)
            if stroke==1:
                drawable.edit_stroke_item(self.thispath)
            if fill>0:
                pdbCall('gimp-image-select-item',{'image': self.img,'operation': 2,'item': self.thispath})
                if fill==3: fill=5
                drawable.edit_fill(fill-1)
            if stroke==2:
                #pdb.gimp_selection_none(self.img)
                drawable.edit_stroke_item(self.thispath)
            pdbCall('gimp-image-select-item',{'image': self.img,'operation': 2,'item': channel})
            #if pdb.gimp_item_is_layer(drawable): pdb.gimp_image_set_active_layer(self.img, drawable)
            #pdb.gimp_image_remove_channel(self.img, channel)
            #drawable.flush()
            self.img.undo_group_end()
        #revisar="""
        if self.useSel.get_active()==True:
            selOpp = self.selOpp.get_active()
            pdbCall('gimp-image-select-item',{'image': self.img,'operation': selOpp,'item': self.thispath})
        Gimp.displays_flush()

    def extraInfo(self,tit1,maxFloat,field=None):
        if isinstance(maxFloat, str):# or isinstance(maxFloat, unicode):
            tx = maxFloat
        else:
            tx = '%.2f'%(maxFloat)
        self.infoETit.set_text(tit1+tx)

    def addbtn(self, widget):
        self.saveToShelf()
        self.selAndFill(None)
        self.thispath = Gimp.Path().new(self.img, self.name)
        self.img.insert_path(self.thispath, None, 0)
        self.change=True
        self.pntsbak=[]
        self.chPath(widget)
        return False

    def chPath(self, widget):
        if self.change==False: return
        lP=self.getShape()
        No, non_empty, x1, y1, x2, y2 = Gimp.Selection.bounds(self.img)

        if non_empty==False: x1,y1,x2,y2=(0,0,self._w(),self._h())

        x1, x2, y1, y2 = self.ui.getValues([self.iL,self.iR,self.iT,self.iB])
        sg = self.shrinkGrow.get_value()
        if sg != 0:
            x1-=sg
            x2+=sg
            y1-=sg
            y2+=sg

        if self.squaSel.get_active()==True:
            an, al=(x2-x1, y2-y1)
            lado = min(an,al)
            if lado!=an:
                x1 = x1 + (an-lado) * 0.5
                x2 = x1 + lado # x2-(an-lado) * 0.5
            if lado!=al:
                y1=y1+(al-lado) * 0.5
                y2=y2-(al-lado) * 0.5
        bezs=[]
        pnts=[]
        shp=SHAPES2[lP]
        
        Def2=shp['def2']
        try:
            name, bezs, xtraTit, xtraVal, closed = Def2(x1,x2,y1,y2, self.Objs)
            if 'img' in SHAPES2[lP]:
                imHlp=SHAPES2[lP]['img']
                # si es array es que se asigna a uno de los objetos
                if type(imHlp)==list:
                    obj=imHlp[0]
                    pthImg=shapesImgPath + imHlp[1][0]
                    vals=getVals(self.Objs)
                    pthImg=shapesImgPath + imHlp[1][vals[imHlp[0]]]
                else:
                    pthImg=shapesImgPath + imHlp
                self.image.set_from_file(pthImg)
            self.extraInfo(xtraTit,xtraVal)
        except Exception as e:
            print(e)
        if (len(bezs)==0): return False
        if type(bezs[0])==list:
            for n in bezs:
                gp = gimppath(n)
                self.transformGimpPath(gp,x1,x2,y1,y2)
                gp.compact()
        else:
            gp = gimppath(bezs)
            gp.compact()
            self.transformGimpPath(gp,x1,x2,y1,y2)
        pnts = gp.toGimpPath()
        self.pnts = self.rand(pnts)
        self.name = name

        if self.pntsbak != self.pnts or self.prevClosed != closed:
            if len(self.thispath.get_strokes())==1:
                self.delStrokes()
                # try:
                #     self.thispath.remove_stroke(self.thispath.get_strokes()[0])
                # except Exception as e:
                #     print(e)
            else:
                vv=Gimp.Path().new(self.img, self.name)
                self.refreshPath(vv)

            if type(bezs[0])==list:
                vv=Gimp.Path().new(self.img, self.name)
                for n in bezs:
                    gp = gimppath(n)
                    pnts = gp.toGimpPath()
                    pnts = self.rand(pnts)
                    vv.stroke_new_from_points(Gimp.PathStrokeType.BEZIER, pnts, closed)
                self.refreshPath(vv)
            else:
                self.delStrokes()
                # try:
                #     if len(self.thispath.get_strokes())>0:
                #         self.thispath.remove_stroke(self.thispath.get_strokes()[0])
                # except Exception as e:
                #     debugErr(str(e))
                self.thispath.stroke_new_from_points(Gimp.PathStrokeType.BEZIER, pnts, closed)

            self.thispath.name = name
            self.thispath.set_visible(True)
            self.pntsbak = self.pnts
            self.prevClosed = closed

    def delStrokes(self):
        if len(self.thispath.get_strokes())>0:
            try:
                self.thispath.remove_stroke(self.thispath.get_strokes()[0])
            except Exception as e:
                print(e)

    def refreshPath(self, vv):
        self.img.remove_path(self.thispath)
        self.img.insert_path(vv, None, 0)
        self.thispath=vv

    def do_query_procedures(self):
        return ["shape-creator-2025"]

    def addObj(self, obj, props, show=False):
        o = obj
        for n in props:
            o.set_property(n, props[n])
        if show == True:
            o.show()
        return o

    def addTV(self,name):
        treestore = Gtk.TreeStore(str,str)
        tv = Gtk.TreeView(model=treestore)
        tv.set_size_request(300, 240)
        self.tvcolumn = Gtk.TreeViewColumn(_('Shapes'))
        tv.append_column(self.tvcolumn)
        self.cell = Gtk.CellRendererText()
        self.tvcolumn.pack_start(self.cell, True)
        self.tvcolumn.add_attribute(self.cell, 'text', 0)
        self.tvcolumn.set_sort_column_id(0)
        setProps(tv,{'search-column':0,'rules-hint':True,'reorderable':True,'show-expanders':True,'enable-tree-lines':True})
        tv.set_grid_lines(Gtk.TreeViewGridLines.BOTH)
        self.tv = tv
        select = self.tv.get_selection()
        select.set_mode(Gtk.SelectionMode.SINGLE)
        sW = Gtk.ScrolledWindow(hadjustment=None, vadjustment=None)
        for n in [Gtk.ShadowType.IN,Gtk.ShadowType.ETCHED_IN]: sW.set_shadow_type(n)
        sW.add(tv)
        sW.set_policy(Gtk.PolicyType.AUTOMATIC,Gtk.PolicyType.AUTOMATIC)

        longName = 0
        maxRows = 0
        for n in SHAPES2:
            tit = SHAPES2[n]['tit']
            iter = None
            if 'grp' in SHAPES2[n]:
                grp = SHAPES2[n]['grp']
                if len(treestore)>0:
                    for i in range(len(treestore)):
                        it=treestore.get_iter(i)
                        if treestore.get_value(it,0)==grp:
                            iter=it
                            break
                if iter==None: iter = treestore.append(None,[grp,''])
            treestore.append(iter,[tit,n])
            maxRows = max(maxRows,len(SHAPES2[n]['objs']))
            longName=max(len(tit),longName)
        try:
            context = tv.get_style_context()
            #revisar style = tv.get_style().copy()
            #revisar tv.set_style(style)
        except Exception as e:
            debug(e)
        self.maxRows=maxRows+1
        tv.show()
        sW.set_size_request(200, 340)
        self.grid._cell(sW, rowSpan=4)
        self.grid._cell('_'*(longName+7), row=1)
        return (treestore,tv,sW)

    def transformGimpPath(self,gp,x1,x2,y1,y2):
        rotShape=self.shapeRot.get_value()
        skX=self.skewX.get_value()
        skY=self.skewY.get_value()

        mirrorX=self.mirrorX.get_active()
        mirrorY=self.mirrorY.get_active()

        cx,cy=(x1+(x2-x1)/2.0,y1+(y2-y1)/2.0)
        if rotShape!=0.0: 
            gp.rotdeg(rotShape,cx,cy)

        if (skX+skY)>0: gp.skew(skX,skY,cx,cy)
        sx,sy=(-1 if mirrorX else 1,-1 if mirrorY else 1)
        if mirrorX or mirrorY:
            gp.translate(-cx if mirrorX else 0,-cy if mirrorY else 0)
            gp.scale(sx,sy)
            gp.translate(cx if mirrorX else 0,cy if mirrorY else 0)

    def evalSpin(self, widget, data=None):
        s=widget.get_text().lower()
        s=s.replace('w',str(self._w()))
        s=s.replace('h',str(self._h()))
        widget.set_value(eval(s))

    def tt(self, w, data=None):
        v = self.parseVal(w.get_text())
        w.set_value(v)

    def _h(self):
        return self.img.get_height()

    def _w(self):
        return self.img.get_width()

    def chRepeat(self, button, name):
        if button.get_active():
            self.repeat_n = name

    def do_create_procedure(self, name):
        proc = Gimp.ImageProcedure.new(
            self, name, Gimp.PDBProcType.PLUGIN, self.run, None)
        proc.set_image_types("*")
        proc.set_sensitivity_mask(Gimp.ProcedureSensitivityMask.DRAWABLE)
        proc.set_menu_label(_("Shapes creator"))
        proc.set_icon_name(GimpUi.ICON_GEGL)
        proc.add_menu_path('<Image>/Filters/Path/')
        proc.set_documentation(
            _("Shapes creator 2025"), _("Shapes Creator 2025"), name)
        proc.set_attribution("Paco Garcia", "Paco Garcia", "2025")
        return proc

    def dlg(self, procedure):
        GimpUi.init("shapes-creator")
        dialog = GimpUi.Dialog(use_header_bar=False, title=_("Shapes Creator 2025"), role="shapes-creator")
        dialog.set_default_size(500, 350)
        dialog.set_border_width(5)
        dialog.set_keep_above(True)
        #dialog.set_position(Gtk.WIN_POS_CENTER)
        dialog.connect("destroy", Gtk.main_quit)
        #dialog.parent.connect("delete-event", self.kobtn)

        box = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=20)
        dialog.get_content_area().add(box)
        box.show()
        self.grid=Grid(box)

        # movido del viejo
        self.nB = self.grid._cell(Gtk.Notebook(), col=1,colSpan=2)
        self.grid._btn(_("Update selection"), col=1,row=2,cnn="clicked", fn=self.updselbtn)
        self.grid._btn(_("Add shape"), col=2,row=2,cnn="clicked", fn=self.addbtn)

        for n in range(0,len(self.tabTits)):
            Gr=Grid()
            self.tabs.append(Gr)
            self.nB.append_page(Gr._grid, Gtk.Label(label=self.tabTits[n]))

        #self.tab2=Grid(self.tabs[0])
        self.tab2= self.tabs[0]
        self.addTV('a')
        self.tabSelection(self.tabs[1])
        self.tabSelFill(self.tabs[2])
        self.tabTransform(self.tabs[3])

        self.change=False
        if self.thispath==None:
            self.thispath = Gimp.Path().new(self.img, self.name)
            self.img.insert_path(self.thispath, None, 0)

        for wg in [self.shapeRot,self.shrinkGrow,self.skewX,self.skewY]:
            wg.connect("activate",self.evalSpin,'activate')
        cancel_button = dialog.add_button(Gtk.STOCK_CANCEL, Gtk.ResponseType.CANCEL)
        cancel_button.connect("clicked", self.kobtn)

        flds=SHAPES2[list(SHAPES2.keys())[0]]
        #if gimpshelf.shelf.has_key(pathcreator_key):
        #    lastshape=gimpshelf.shelf[pathcreator_key]['lastshape']
        #    tS.foreach(self.match_value_cb, (lastshape,tv))
        self.tv.get_selection().connect("changed", self.chShape)
        self.chShape(None)
        # FIN

        while (True):
            response = dialog.run()
            if response == Gtk.ResponseType.CANCEL:
                dialog.destroy()
                return procedure.new_return_values(Gimp.PDBStatusType.CANCEL,  GLib.Error())

    def kobtn(self, widget, event=None):
        #if pdb.gimp_item_is_valid(self.thispath):
        self.img.remove_path(self.thispath)
        #pdb.gimp_image_remove_vectors(self.img, self.thispath)

    def tabSelFill(self,tab):
        self.selStroke = tab._cellLb(_('Stroke path')+':', self.ui.makeCombo(oppStro),rowInc=1)
        tab._cellLb(_('Current brush')+':',Gtk.Label(label=self.brushDetails()),rowInc=1)
        self.fillFg=tab._cellLb(_('Fill')+':', self.ui.makeCombo(oppFill),rowInc=1)
        #self.newLayer=tab._cell(self.ui.chBtn(_("Add new layer for fill-stroke")), colSpan=2,rowInc=1)
        self.useSel=tab._cell(self.ui.chBtn(_("Use as selection")), colSpan=2, cnn="toggled", fn=self.checkSel,rowInc=1)
        self.selOpp = tab._cellLb(_('Operation')+':', self.ui.makeCombo(oppSel))
        #self.selOpp.set_sensitive(False) #14

    def _cellInfo(self, txLab, iniCell, val, maxValue, name, rInc=None):
        sb = self.ui.spinBtn(self.ui._adj(val, 0, maxValue, 1))
        este = self.tabs[1]._cellLb(txLab, sb, col=iniCell, rowInc=rInc)
        este.set_name(name)
        este.connect("activate",self.evalSpin,'activate')
        esteFn=este.connect("changed", self.chDim)
        return [este,esteFn]

    def tabSelection(self, tab):
        ddd = dims(self.img)
        self.iW,self.iWFn=self._cellInfo(_('Width')+':', 1, ddd.sw, ddd.w, 'iW')
        self.iH,self.iHFn=self._cellInfo(_('Height')+':',3, ddd.sh, ddd.h, 'iH', rInc=1)
        self.iL,self.iLFn=self._cellInfo(_('Left')+':', 1, ddd.l, ddd.w, 'iL')
        self.iR,self.iRFn=self._cellInfo(_('Right'+':'),3, ddd.r, ddd.w, 'iR', rInc=1)
        self.iT,self.iTFn=self._cellInfo(_('Top')+':',   1, ddd.t, ddd.h, 'iT')
        self.iB,self.iBFn=self._cellInfo(_('Bottom')+':',3, ddd.b, ddd.h, 'iB', rInc=1)
        tab._cell(_('Shrink/Grow'), col=1, colSpan=1, rowInc=1)
        ADJ = Gtk.Adjustment(value=0, lower=-200, upper=200, step_increment=1)
        sb = Gtk.SpinButton(adjustment=ADJ, climb_rate=0.0, digits=0)
        self.shrinkGrow=tab._cell(sb,col= 2,cnn= "changed",fn= self.chPath, rowInc=1)
        self.squaSel = tab._cell(Gtk.CheckButton(label=_("Square selection")), colSpan= 5, cnn="toggled", fn=self.chPath)

    def brushDetails(self):
        brush = Gimp.context_get_brush()
        angle = _("Angle") +': ' + str(brush.get_angle()) + '\n'
        aspect = _("Aspect")+': ' + str(brush.get_aspect_ratio())+'\n'
        size = _("Size") + ': ' + str(Gimp.context_get_brush_size())
        return str(brush.get_name()) + '\n' + angle + aspect+ size

    def checkSel(self, widget, data=None):
        self.selOpp.set_sensitive(widget.get_active())

    def chSizeVal(self, obj, objSignal, value):
        # disable the on change function, change the value and enable the function again
        if type(obj)==list:
             obj=obj[0]
        obj.disconnect(objSignal)
        obj.set_value(value)
        objSignal = obj.connect("changed", self.chDim)
        return objSignal

    def run(self, procedure, run_mode, image, drawables, config, run_data):
        if len(drawables) != 1:
            msg = _("Procedure '{}' only works with one drawable.").format(
                procedure.get_name())
            error = GLib.Error.new_literal(Gimp.PlugIn.error_quark(), msg, 0)
            return procedure.new_return_values(Gimp.PDBStatusType.CALLING_ERROR, error)
        self.img = image
        if self.thispath == None:
            self.thispath = Gimp.Path().new(self.img, "new-shape")
            self.img.insert_path(self.thispath, None, -1)
        if run_mode == Gimp.RunMode.INTERACTIVE:
            return self.dlg(procedure)
        return procedure.new_return_values(Gimp.PDBStatusType.SUCCESS, GLib.Error())

    def rand(self,pnts):
        rMin,rMax=self.ui.getValues((self.RandMin,self.RandMax))
        if rMin==0 and rMax==0:
            return pnts
        for n in range(0,len(pnts)):
            pnts[n]=pnts[n]+random.uniform(rMin,rMax)
        return pnts

    def numF(self,n):
        if n=='w': n=self._w()
        if n=='h': n=self._h()
        return n

    def on_spin_button_key_press(self, widget, event):
        if event.keyval == Gdk.KEY_Return or event.keyval == Gdk.KEY_KP_Enter:
            print(str(widget))
            s=widget.get_text().lower()
            s=s.replace('w',str(self._w()))
            s=s.replace('h',str(self._h()))
            widget.set_value(eval(s))
            return False
        return False

    def chShape(self, widget):
        lP = self.getShape() #self.ui.getModelVal(widget)
        if lP=="": return
        objs = SHAPES2[lP]['objs']
        row = 0
        self.Objs = []
        self.change = False
        ttab=self.tab2
        ttab.clear()
        for n in objs:
            T, lab = (n['t'],n['label'])
            lb = None
            if T == 'tit': ob = ttab._cell(lab, colSpan= 3, row=row)
            if T == 'float':
                adj = n['adj']
                ADJ = self.ui._adj(self.numF(adj[0]), self.numF(adj[1]), self.numF(adj[2]), self.numF(adj[3]))
                obj = Gtk.SpinButton(adjustment=ADJ, climb_rate=0.0, digits=n['digits'])
                obj.connect("activate",self.evalSpin,'activate')
                obj.connect("key-press-event", self.on_spin_button_key_press)
            if T=='combo': obj=self.ui.makeCombo(n['vals'])
            if T=='check':
                ob=ttab._cell(Gtk.CheckButton(label=n['tx']),row=row, cnn="toggled", fn=self.chPath, col=0, colSpan=3)
            if T in ['float','combo']:
                lb = ttab._cell(lab, row=row)
                ob = ttab._cell(obj, col=1, row=row, cnn='changed', fn=self.chPath)
            if T=='radio':
                c = 1
                if 'dir' in n:
                    tabla= Grid()
                    self.tab2._cell(tabla._grid,row=row, col=1, colSpan=len(n['vals']))
                else:
                    tabla=self.tab2
                r = 0 if 'dir' in n else row
                lb=self.tab2._cell(lab, row=row)
                btn = None
                ob=[]
                for v in n['vals']:
                    btn=self.ui.rBtn(btn,v[0])
                    ob.append(btn)
                    tabla._cell(btn, col=c,row= r,cnn="toggled",fn=self.chPath)
                    if 'dir' in n:
                        c += 1
                    else:
                        r += 1
                row = row+r+1
            if T != 'tit':
                self.Objs.append({'obj':ob,'lb':lb})
                self.setVal(ob,lP)
            row += 1
        if 'img' in SHAPES2[lP]:
            imHlp=SHAPES2[lP]['img']
            # si es array es que se asigna a uno de los objetos
            if type(imHlp)==list:
                pthImg=shapesImgPath + imHlp[1][imHlp[0]]
            else:
                pthImg=shapesImgPath + imHlp
            self.image = Gtk.Image()
            self.image.set_from_file(pthImg)
            ttab._cell(self.image, colSpan=2, row=row)
            row += 2
        # add debug labels
        self.infoETit = ttab._cell('', colSpan=2, row=row+2, rowSpan=self.maxRows+1)
        self.setLabels()
        # asignar valores
        defVals=None
        defs=shelf.read_all()
        if lP in defs:
            defVals=defs[lP]
        self.change = True
        self.chPath(widget)

    def setVal(self,obj,lP):
        defs=shelf.read_all()
        vals=defs.get(lP)
        if vals:
            for n in range(0,len(self.Objs)):
                try:
                    obj=self.Objs[n]['obj']
                    if type(obj) is Gtk.SpinButton: obj.set_value(vals[n])
                    if type(obj) is list: obj[vals[n]].set_active(True)
                    if type(obj) is Gtk.ComboBox: obj.set_active(vals[n])
                except Exception as e:
                    debugErr(e)

    def setLabels(self):
        self.change = False
        ch_path = False
        defs=shelf.read_all()
        lP = self.getShape()
        vals=defs.get(lP)
        if vals:
           ch_path = True
        if (ch_path): self.chPath(self)
        self.change=True

    def tabTransform(self, tab):
        adjRot=self.ui._adj(0,-360,360,1)
        self.shapeRot=tab._cellLb(_("Rotation")+":", self.ui.spinBtn(adjRot, 0.0, 0), cnn='changed', fn=self.chPath, rowInc=1)
        tab._cell(_('Skew')+':', rowInc=1)
        adjSkewX=self.ui._adj(0,-360,360,1)
        adjSkewY=self.ui._adj(0,-360,360,1)
        self.skewX=tab._cellLb('X:', self.ui.spinBtn(adjSkewX, 0.0, 0), cnn='changed', fn=self.chPath)
        self.skewY=tab._cellLb('Y:', self.ui.spinBtn(adjSkewY, 0.0, 0), col=2, cnn='changed', fn=self.chPath,  rowInc=1)
        self.mirrorX=tab._cell(self.ui.chBtn(_("Mirror X")), col=1, colSpan=2, cnn='toggled', fn=self.chPath)
        self.mirrorY=tab._cell(self.ui.chBtn(_("Mirror Y")), col=3, colSpan=2, cnn='toggled', fn=self.chPath, rowInc=1)
        tab._cell(_('Add random')+':', colSpan=4, rowInc=1)
        adjRandMin=self.ui._adj(0,-100.0,100.0,0.2)
        adjRandMax=self.ui._adj(0,-100.0,100.0,0.2)
        self.RandMin=tab._cellLb(_('From')+":", self.ui.spinBtn(adjRandMin, 0.0, 1), cnn='changed', fn=self.chPath)
        self.RandMax=tab._cellLb(_("To")+':', self.ui.spinBtn(adjRandMax, 0.0, 1), col=2, cnn='changed', fn=self.chPath, rowInc=1)

Gimp.main(ShapeCreator2025.__gtype__, sys.argv)
# 815 996 794