# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
# from . import nice
import bpy
import bpy.utils.previews

from . utils import *

from . langs import *

# box2Classes = [ OBJECT_PT_box2panel, MeshesPanel]
box2Classes = [box2props, OBJECT_OT_addBox2, MP_PT_meshesPanel]


def register():
    for cls in box2Classes:
        bpy.utils.register_class(cls)
    bpy.types.VIEW3D_MT_mesh_add.append(addBox2_button)
    bpy.app.translations.register(__name__, langs)


def unregister():
    for cls in box2Classes:
        bpy.utils.unregister_class(cls)
    bpy.types.VIEW3D_MT_mesh_add.remove(addBox2_button)
    bpy.app.translations.unregister(__name__)
