from .arakne_geosphere import GeoSphere
import bpy
from bpy.types import Operator, PropertyGroup
from bpy.props import FloatVectorProperty, IntProperty, PointerProperty, FloatProperty, EnumProperty, BoolProperty
from bpy_extras.object_utils import AddObjectHelper, object_data_add
from mathutils import Vector as V
from . tools import *

# -----------------------------------------------------------
def on_enum_change(self, context):
    objs = self.objs
    if (objs != 'None'):
        vals = objBBox(objs)
        self.vertex1 = vals[0]
        self.vertex2 = vals[1]
    return None


class box2props(PropertyGroup):
    corner1desc = "First corner for the bounding box of the object"
    corner2desc = "Second corner for the bounding box of the object"
    typeItems = (
        ('bevel', "Bevel edges", "Bevel all the edges"),
        ('corners', "Crop corners", "Crop all the corners"),
        ('defl', "Deflate faces", "Deflate"),
        ('deflreg', "Deflate regular", "Deflate"),
        ('oct', "Inscribed octahedron", "Octahedron"),
        ('round', "Rounded edges", "Rounded"),
        ('sep', "Separate faces", "Separate sides"),
        ('sunken', "Sunken edges", "Sunken all the edges")
    )
    vertex1: FloatVectorProperty(name="Corner 1", description=corner1desc,
                                 # type: ignore
                                 default=(-1, -1, -1), subtype='TRANSLATION')
    vertex2: FloatVectorProperty(name="Corner 2", description=corner2desc, default=(
        1, 1, 1), subtype='TRANSLATION')  # type: ignore
    sep: FloatProperty(
        name="Distance", description="Value to apply to the resulting shape", default=0.2)  # type: ignore
    octa: BoolProperty(name="Inscribed octahedron",
                       description="Inscribed octahedron", default=False)  # type: ignore
    type: EnumProperty(
        name="Effect", description="Choose the effect to apply", items=typeItems)  # type: ignore
    subdivs: IntProperty(name="Subdivisions", description="Subdivisions",
                         default=3, min=1, max=6)  # type: ignore
    inv: BoolProperty(name="Inverse", description="Inverse", default=False)  # type: ignore
    objs: EnumProperty(name="Object", items=list_objs, update=on_enum_change)  # type: ignore


def addBox2(self, context):
    V1 = self.corners.vertex1
    V2 = self.corners.vertex2
    sep = self.corners.sep
    type = "" if sep == 0 else self.corners.type
    inv = self.corners.inv
    octa = self.corners.octa
    subdivs = self.corners.subdivs
    vrts, edges, faces = box2points(V1, V2, sep, type, inv, octa, subdivs)
    meshname = 'box2'
    mesh = bpy.data.meshes.new(name=meshname)
    self.meshname = mesh.name
    mesh.from_pydata(vrts, edges, faces)
    object_data_add(context, mesh, operator=self)


class OBJECT_OT_addBox2(Operator, AddObjectHelper):
    import os
    bl_idname = 'mesh.add_box_2'
    bl_label = "Box from corners"
    bl_icon = os.path.join(os.path.dirname(__file__), 'icons', 'mesh_cube.png')
    bl_options = {'REGISTER', 'UNDO'}
    corners: PointerProperty(
        type=box2props, name='corners', description="Corners of the Box")  # type: ignore

    @classmethod
    def poll(cls, context):
        return True

    def draw(self, context):
        lay = self.layout
        lay.prop(self.corners, 'vertex1')
        lay.prop(self.corners, 'vertex2')
        lay.label(text='Corners from object bounding box')
        lay.prop(self.corners, 'objs')
        lay.prop(self.corners, 'sep')
        if self.corners.sep != 0:
            lay.prop(self.corners, 'type')
        else:
            lay.prop(self.corners, 'octa')
        if self.corners.type not in ['oct', 'defl', 'deflreg', 'round'] and self.corners.sep != 0:
            lay.prop(self.corners, 'inv')
        if self.corners.type == 'round':
            lay.prop(self.corners, 'subdivs')

    def execute(self, context):
        self.location = (0.0, 0.0, 0.0)
        addBox2(self, context)
        return {'FINISHED'}


def addBox2_button(self, context):
    global pcoll
    self.layout.operator(OBJECT_OT_addBox2.bl_idname,
                         text="Box from corners", icon_value=pcoll['MESH_CUBE'].icon_id)


def nV(a, b, c, A=0, B=0, C=0):
    return V((a.x+A, b.y+B, c.z+C))


def cuad(faces, verts, i1, i2, i3, i4):

    if verts[i1] != verts[i2] and verts[i2] != verts[i3] and verts[i3] != verts[i4]:
        faces.append([i1, i2, i4, i3])
    else:
        if verts[i1] != verts[i2] and verts[i2] != verts[i3]:
            faces.append([i1, i2, i3])
        if verts[i2] != verts[i4] and verts[i4] != verts[i3]:
            faces.append([i2, i4, i3])


def box2points(V1, V2, sep, type, inv, octa, subdivs=3):
    v1 = V((min(V1[0], V2[0]), min(V1[1], V2[1]), min(V1[2], V2[2])))
    v2 = V((max(V1[0], V2[0]), max(V1[1], V2[1]), max(V1[2], V2[2])))
    vBox = [nV(v1, v2, v1), nV(v2, v2, v1), nV(v2, v1, v1), v1,
            nV(v1, v2, v2), v2, nV(v2, v1, v2), nV(v1, v1, v2)]
    vm = vMid(v1, v2)
    if sep == 0:
        edges = []
        if type == 'oct' or octa:
            vrts = [nV(v1, vm, vm), nV(v2, vm, vm), nV(vm, v1, vm),
                    nV(vm, v2, vm), nV(vm, vm, v1), nV(vm, vm, v2)]
            faces = [[0, 2, 5], [5, 3, 0], [1, 3, 5], [2, 1, 5],
                     [2, 4, 1], [0, 4, 2], [0, 3, 4], [4, 3, 1]]
        else:
            vrts = vBox
            faces = [
                [0, 1, 2, 3], [7, 6, 5, 4], [4, 5, 1, 0], [
                    6, 7, 3, 2], [0, 3, 7, 4], [5, 6, 2, 1]
            ]
    else:
        M1 = nV(v1, v1, v1, sep, sep, sep)
        M2 = nV(v2, v2, v2, -sep, -sep, -sep)
        vrts = [
            nV(M1, M1, v1), nV(M2, M1, v1), nV(M1, M2, v1), nV(M2, M2, v1),
            nV(M1, M1, v2), nV(M2, M1, v2), nV(M1, M2, v2), nV(M2, M2, v2),
            nV(v1, M1, M1), nV(v1, M1, M2), nV(v1, M2, M2), nV(v1, M2, M1),
            nV(v2, M1, M1), nV(v2, M1, M2), nV(v2, M2, M2), nV(v2, M2, M1),
            nV(M1, v1, M1), nV(M1, v1, M2), nV(M2, v1, M2), nV(M2, v1, M1),
            nV(M1, v2, M1), nV(M1, v2, M2), nV(M2, v2, M2), nV(M2, v2, M1)
        ]
        edges = []
        faces = [[2, 3, 1, 0], [4, 5, 7, 6], [8, 9, 10, 11], [
            15, 14, 13, 12], [19, 18, 17, 16], [20, 21, 22, 23]]
        vSep = [M1, nV(M2, M1, M1), nV(M1, M2, M1), nV(M2, M2, M1), nV(
            M1, M1, M2), nV(M2, M1, M2), nV(M1, M2, M2), nV(M2, M2, M2)]

        # for wire and beveInv
        facesExt = [
            [31, 28, 10, 9], [24, 27, 8, 11], [30, 31, 17, 18],
            [27, 31, 9, 8], [27, 24, 2, 0], [10, 28, 24, 11],
            [28, 21, 20, 24], [31, 4, 6, 28], [31, 30, 5, 4],
            [27, 16, 17, 31], [24, 20, 23, 25], [22, 29, 25, 23],
            [28, 29, 22, 21], [24, 25, 3, 2], [29, 14, 15, 25],
            [1, 3, 25, 26], [1, 26, 27, 0], [26, 19, 16, 27],
            [12, 13, 30, 26], [25, 15, 12, 26], [29, 30, 13, 14],
            [7, 5, 30, 29], [28, 6, 7, 29], [30, 18, 19, 26]
        ]

        if type == 'oct':
            vrts = [
                nV(v1, vm, vm, 0, sep, sep), nV(v1, vm, vm, 0, -sep, sep),
                nV(v1, vm, vm, 0, -sep, -sep), nV(v1, vm, vm, 0, sep, -sep),
                nV(v2, vm, vm, 0, sep, sep), nV(v2, vm, vm, 0, -sep, sep),
                nV(v2, vm, vm, 0, -sep, -sep), nV(v2, vm, vm, 0, sep, -sep),
                nV(vm, v1, vm, sep, 0, sep), nV(vm, v1, vm, sep, 0, -sep),
                nV(vm, v1, vm, -sep, 0, -sep), nV(vm, v1, vm, -sep, 0, sep),
                nV(vm, v2, vm, sep, 0, sep), nV(vm, v2, vm, sep, 0, -sep),
                nV(vm, v2, vm, -sep, 0, -sep), nV(vm, v2, vm, -sep, 0, sep),
                nV(vm, vm, v1, sep, sep, 0), nV(vm, vm, v1, sep, -sep, 0),
                nV(vm, vm, v1, -sep, -sep, 0), nV(vm, vm, v1, -sep, sep, 0),
                nV(vm, vm, v2, sep, sep, 0), nV(vm, vm, v2, sep, -sep, 0),
                nV(vm, vm, v2, -sep, -sep, 0), nV(vm, vm, v2, -sep, sep, 0)
            ]
            faces = [
                [23, 22, 21, 20], [11, 10, 9, 8], [16, 17, 18, 19],
                [12, 13, 14, 15], [3, 2, 1, 0], [4, 5, 6, 7],
                [0, 1, 22, 23], [12, 15, 23, 20], [11, 8, 21, 22],
                [5, 4, 20, 21], [10, 18, 17, 9], [7, 6, 17, 16],
                [13, 16, 19, 14], [2, 3, 19, 18], [1, 2, 10, 11],
                [8, 9, 6, 5], [4, 7, 13, 12], [15, 14, 3, 0],
                [3, 14, 19], [2, 18, 10], [21, 8, 5], [6, 9, 17],
                [20, 4, 12], [7, 16, 13], [1, 11, 22], [15, 0, 23]
            ]
        if type == 'defl':
            vrts = vBox
            vrts.extend([
                nV(v1, vm, vm, sep, 0, 0), nV(v2, vm, vm, -sep, 0, 0),
                nV(vm, v1, vm, 0, sep, 0), nV(vm, v2, vm, 0, -sep, 0),
                nV(vm, vm, v1, 0, 0, sep),
                V((vm.x, vm.y, v2.z-sep))])
            faces = [
                [8, 7, 4], [3, 7, 8], [0, 3, 8], [8, 4, 0],
                [5, 9, 1], [9, 2, 1], [2, 9, 6], [6, 9, 5],
                [10, 6, 7], [10, 2, 6], [2, 10, 3], [10, 7, 3],
                [4, 5, 11], [0, 4, 11], [1, 11, 5], [0, 11, 1],
                [13, 7, 6], [13, 4, 7], [13, 5, 4], [13, 6, 5],
                [12, 3, 0], [12, 2, 3], [1, 2, 12], [12, 0, 1]
            ]

        if type == 'deflreg':
            vrts = vBox
            w = [x / 2.0 for x in [v2[0]-v1[0], v2[1]-v1[1], v2[2]-v1[2]]]
            md = min(w)
            bottomV = [
                vrts[0] + V((md, -md, sep)),
                vrts[1] + V((-md, -md, sep)),
                vrts[2] + V((-md, md, sep)),
                vrts[3] + V((md, md, sep))
            ]
            vrts.extend(bottomV)
            faces = []
            cuad(faces, vrts, 0, 1, 8, 9)
            cuad(faces, vrts, 1, 2, 9, 10)
            cuad(faces, vrts, 0, 8, 3, 11)
            cuad(faces, vrts, 2, 3, 10, 11)
            cuad(faces, vrts, 9, 10, 8, 11)  # close
            topV = [
                vrts[4] + V((md, -md, -sep)),
                vrts[5] + V((-md, -md, -sep)),
                vrts[6] + V((-md,  md, -sep)),
                vrts[7] + V((md, md, -sep)),
            ]
            vrts.extend(topV)
            cuad(faces, vrts, 5, 4, 13, 12)
            cuad(faces, vrts,  7, 15, 4, 12)
            cuad(faces, vrts,  6, 14, 7, 15)
            cuad(faces, vrts,  13, 14, 5, 6)
            cuad(faces, vrts,  12, 15, 13, 14)  # close
            leftV = [
                vrts[0] + V((md, -sep, md)),  # 16
                vrts[1] + V((-md, -sep, md)),
                vrts[4] + V((md, -sep,  -md)),
                vrts[5] + V((-md, -sep, -md)),
            ]
            vrts.extend(leftV)
            cuad(faces, vrts, 0, 16, 1, 17)
            cuad(faces, vrts, 5, 19, 4, 18)
            cuad(faces, vrts, 17, 19, 1, 5)
            cuad(faces, vrts, 18, 16, 4, 0)
            cuad(faces, vrts, 16, 18, 17, 19)  # close
            rightV = [
                vrts[2] + V((-md, sep, md)),  # 20
                vrts[3] + V((md, sep, md)),
                vrts[6] + V((-md, sep,  -md)),
                vrts[7] + V((md, sep, -md)),
            ]
            vrts.extend(rightV)
            cuad(faces, vrts, 23, 22, 7, 6)
            cuad(faces, vrts, 7, 3, 23, 21)
            cuad(faces, vrts, 21, 3, 20, 2)
            cuad(faces, vrts, 22, 20, 6, 2)
            cuad(faces, vrts, 23, 21, 22, 20)  # close
            frontV = [
                vrts[1] + V((-sep, -md, md)),  #
                vrts[2] + V((-sep, md, md)),
                vrts[5] + V((-sep, -md,  -md)),
                vrts[6] + V((-sep, md, - md)),
            ]
            vrts.extend(frontV)
            cuad(faces, vrts, 6, 27, 5, 26)
            cuad(faces, vrts, 5, 26, 1, 24)
            cuad(faces, vrts, 1, 24, 2, 25)
            cuad(faces, vrts, 2, 25, 6, 27)
            cuad(faces, vrts, 26, 27, 24, 25)  # close
            backV = [
                vrts[0] + V((sep, -md, md)),
                vrts[3] + V((sep, md, md)),
                vrts[4] + V((sep, -md, -md)),
                vrts[7] + V((sep, md, -md)),
            ]
            vrts.extend(backV)
            cuad(faces, vrts, 4, 30, 7, 31)
            cuad(faces, vrts, 7, 31, 3, 29)
            cuad(faces, vrts, 3, 29, 0, 28)
            cuad(faces, vrts, 0, 28, 4, 30)
            cuad(faces, vrts, 31, 30, 29, 28)  # close

        if type == 'sep' and inv:
            vrts.extend(vBox)
            vrts.append(nV(M1, M1, v1))
            faces = facesExt

        if type == 'bevel':
            common = [[13, 5, 7, 14], [4, 17, 9], [5, 13, 18], [14, 7, 22], [21, 6, 10], [4, 5, 18, 17],
                      [10, 6, 4, 9], [22, 7, 6, 21], [0, 8, 16], [
                          14, 22, 23, 15], [19, 1, 0, 16], [23, 3, 15],
                      [20, 11, 2], [12, 15, 3, 1], [10, 11, 20, 21], [
                          17, 16, 8, 9], [1, 19, 12], [2, 11, 8, 0], [2, 3, 23, 20],
                      [13, 12, 19, 18]]
            if inv:
                vrts.extend(vBox)
                faces = facesExt
                faces.extend(common)
            else:
                for i in common:
                    i.reverse()
                faces.extend(common)

        if type == 'sunken' and inv == False:
            vrts.extend((vSep))
            faces.extend([
                [27, 26, 20, 23], [3, 2, 26, 27], [27, 25, 1, 3],
                [15, 12, 25, 27], [2, 0, 24, 26], [26, 24, 8, 11],
                [25, 24, 0, 1], [19, 16, 24, 25], [7, 5, 29, 31],
                [31, 29, 13, 14], [22, 21, 30, 31], [31, 30, 6, 7],
                [10, 9, 28, 30], [30, 28, 4, 6], [29, 28, 17, 18],
                [5, 4, 28, 29], [25, 29, 18, 19], [12, 13, 29, 25],
                [14, 15, 27, 31], [31, 27, 23, 22], [21, 20, 26, 30],
                [30, 26, 11, 10], [9, 8, 24, 28], [28, 24, 16, 17]
            ])

        if type == 'sunken' and inv == True:
            vrts.extend(vBox + vSep)
            faces = facesExt
            faces.extend([
                [38, 36, 9, 10], [11, 8, 32, 34], [6, 4, 36, 38],
                [0, 2, 34, 32], [36, 4, 5, 37], [17, 36, 37, 18],
                [32, 8, 9, 36], [36, 17, 16, 32], [11, 34, 38, 10], [
                    34, 20, 21, 38], [23, 20, 34, 35], [2, 3, 35, 34],
                [1, 33, 35, 3], [32, 33, 1, 0], [18, 37, 33, 19], [
                    12, 33, 37, 13], [14, 39, 35, 15], [7, 6, 38, 39],
                [22, 39, 38, 21], [15, 35, 33, 12], [39, 22, 23, 35], [
                    16, 19, 33, 32], [5, 7, 39, 37], [37, 39, 14, 13]
            ])
        if type == 'corners':
            vrts = [
                # 0-7 bottom
                nV(M1, v1, v1), nV(v1, M1, v1), nV(v1, M2, v1), nV(M1, v2, v1),
                nV(M2, v2, v1), nV(v2, M2, v1), nV(v2, M1, v1), nV(M2, v1, v1),
                # 8-15 top
                nV(M1, v1, v2), nV(v1, M1, v2), nV(v1, M2, v2), nV(M1, v2, v2), nV(
                    M2, v2, v2), nV(v2, M2, v2), nV(v2, M1, v2), nV(M2, v1, v2),
                nV(v1, v1, M1), nV(v1, v1, M2), nV(v1, v2, M1), nV(v1, v2, M2), nV(v2, v2, M1), nV(v2, v2, M2), nV(v2, v1, M1), nV(v2, v1, M2)]
            common = [[16, 1, 0], [8, 9, 17], [18, 3, 2], [10, 11, 19], [
                20, 5, 4], [21, 12, 13], [14, 15, 23], [22, 7, 6]]
            if inv:
                for i in common:
                    i.reverse()
                vrts.extend(vBox)
                faces = common
                faces.extend([
                    [13, 21, 29], [12, 29, 21], [29, 12, 13], [
                        28, 10, 11], [28, 11, 19],
                    [28, 19, 10],
                    [9, 17, 31], [8, 31, 17], [31, 8, 9], [
                        23, 30, 15], [30, 14, 15], [14, 30, 23],
                    [1, 27, 16], [27, 0, 16], [27, 1, 0], [
                        7, 26, 22], [7, 6, 26], [26, 6, 22],
                    [18, 3, 24], [24, 2, 18], [3, 2, 24], [
                        5, 25, 20], [25, 4, 20], [5, 4, 25]
                ])
            else:
                faces = [[0, 1, 2, 3, 4, 5, 6, 7], [15, 14, 13, 12, 11, 10, 9, 8], [16, 17, 9, 10, 19, 18, 2, 1],
                         [20, 4, 3, 18, 19, 11, 12, 21], [
                             22, 6, 5, 20, 21, 13, 14, 23],
                         [15, 8, 17, 16, 0, 7, 22, 23]
                         ]
                faces.extend(common)
        if type == 'round':
            geo_sph = GeoSphere()
            geo_sph.create_geodesic_sphere(subdivisions=subdivs)
            aa1, bb1, ix1, iy1, iz1 = geo_sph.transform(
                vSep[0], (-sep, -sep, -sep), len(vrts), 1)
            vrts.extend(aa1)
            faces.extend(bb1)

            aa2, bb2, ix2, iy2, iz2 = geo_sph.transform(
                vSep[1], (sep, -sep, -sep), len(vrts), 0)
            vrts.extend(aa2)
            faces.extend(bb2)

            aa, bb, ix3, iy3, iz3 = geo_sph.transform(
                vSep[2], (-sep, sep, -sep), len(vrts), 0)
            vrts.extend(aa)
            faces.extend(bb)

            aa, bb, ix4, iy4, iz4 = geo_sph.transform(
                vSep[3], (sep, sep, -sep), len(vrts), 1)
            vrts.extend(aa)
            faces.extend(bb)

            ####################
            aa, bb, ix5, iy5, iz5 = geo_sph.transform(
                vSep[4], (-sep, -sep, sep), len(vrts), 0)
            vrts.extend(aa)
            faces.extend(bb)
            aa, bb, ix6, iy6, iz6 = geo_sph.transform(
                vSep[5], (sep, -sep, sep), len(vrts), 1)
            vrts.extend(aa)
            faces.extend(bb)
            aa, bb, ix7, iy7, iz7 = geo_sph.transform(
                vSep[6], (-sep, sep, sep), len(vrts), 1)
            vrts.extend(aa)
            faces.extend(bb)
            aa, bb, ix8, iy8, iz8 = geo_sph.transform(
                vSep[7], (sep, sep, sep), len(vrts), 0)
            vrts.extend(aa)
            faces.extend(bb)

            for n in range(len(ix1)-1):
                faces.extend([
                    (ix2[n], ix2[n+1], ix1[n+1], ix1[n]),
                    (ix3[n], ix3[n+1], ix4[n+1], ix4[n]),
                    (ix5[n], ix5[n+1], ix6[n+1], ix6[n]),
                    (ix8[n], ix8[n+1], ix7[n+1], ix7[n]),
                    (iy3[n], iy3[n+1], iy1[n+1], iy1[n]),
                    (iy2[n], iy2[n+1], iy4[n+1], iy4[n]),
                    (iy5[n], iy5[n+1], iy7[n+1], iy7[n]),
                    (iy8[n], iy8[n+1], iy6[n+1], iy6[n]),
                    (iz5[n], iz5[n+1], iz1[n+1], iz1[n]),
                    (iz3[n], iz3[n+1], iz7[n+1], iz7[n]),
                    (iz2[n], iz2[n+1], iz6[n+1], iz6[n]),
                    (iz8[n], iz8[n+1], iz4[n+1], iz4[n])
                ])
    return vrts, edges, faces
