# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.


import bpy
from . utils import *
from . langs import *


class MP_PT_meshesPanel(bpy.types.Panel):
    bl_label = "Extra meshes"
    bl_space_type = 'VIEW_3D'
    bl_idname = 'MP_PT_meshesPanel'
    bl_region_type = 'UI'
    bl_options = {'HEADER_LAYOUT_EXPAND'}

    def draw(self, context):
        layout = self.layout
        col = layout.column(align=True)
        col.operator('mesh.add_box_2', icon_value=pcoll['MESH_CUBE'].icon_id)
        col = layout.column(align=True)
        col.operator('mesh.add_cyl_2', icon_value=pcoll['MESH_CYL'].icon_id)
        col = layout.column(align=True)
        col.operator('mesh.add_tor_2', icon_value=pcoll['MESH_TOR'].icon_id)

box2Classes = [box2props, OBJECT_OT_addBox2, cyl2props, tor2props, OBJECT_OT_addCyl2, MP_PT_meshesPanel,
               OBJECT_OT_addTorus2]

def register():
    for cls in box2Classes:
        bpy.utils.register_class(cls)
    bpy.types.VIEW3D_MT_mesh_add.append(addBox2_button)
    bpy.types.VIEW3D_MT_mesh_add.append(addConeCyl2_button)
    bpy.types.VIEW3D_MT_mesh_add.append(addTorus2_button)
    bpy.types.Scene.cyl2p = PointerProperty(type=cyl2props)
    bpy.types.Scene.tor2p = PointerProperty(type=tor2props)

    bpy.app.translations.register(__name__, langs)


def unregister():
    for cls in box2Classes:
        bpy.utils.unregister_class(cls)
    bpy.types.VIEW3D_MT_mesh_add.remove(addBox2_button)
    bpy.types.VIEW3D_MT_mesh_add.remove(addConeCyl2_button)
    bpy.types.VIEW3D_MT_mesh_add.remove(addTorus2_button)
    bpy.app.translations.unregister(__name__)
    del bpy.types.Scene.cyl2p
    del bpy.types.Scene.tor2p






























