import os
import bpy
import bpy.utils.previews
from mathutils import Vector as V

def vMid(v1, v2):
    return V((v1.x+(v2.x-v1.x)/2, v1.y+(v2.y-v1.y)/2, v1.z+(v2.z-v1.z)/2))

dir = os.path.join(os.path.split(os.path.dirname(__file__))[0], 'icons')
pcoll = bpy.utils.previews.new()

for entry in os.scandir(dir):
    if entry.name.endswith('.svg'):
        name = os.path.splitext(entry.name)[0]
        pcoll.load(name.upper(), entry.path, 'IMAGE')

def objBBox(nom):
    obj = bpy.data.objects.get(nom)
    bbw = [obj.matrix_world @ V(corner) for corner in obj.bound_box]
    mins = V((min(v.x for v in bbw), min(
        v.y for v in bbw), min(v.z for v in bbw)))
    maxs = V((max(v.x for v in bbw), max(
        v.y for v in bbw), max(v.z for v in bbw)))
    return [mins, maxs]

def get_bbox(objects):
    if not objects:
        return None
    minV = [float('inf'), float('inf'), float('inf')]
    maxV = [float('-inf'), float('-inf'), float('-inf')]
    for obj in objects:
        if obj.type not in {'MESH', 'CURVE', 'SURFACE', 'META'}:
            continue
        gbbox = [obj.matrix_world @ V(corner) for corner in obj.bound_box]
        for v in gbbox:
            minV = [min(minV[0], v.x), min(minV[1], v.y), min(minV[2], v.z)]
            maxV = [max(maxV[0], v.x), max(maxV[1], v.y), max(maxV[2], v.z)]
    return minV, maxV

def list_objs(self, context):
    arrObjs = [("None", "Select one", "")]
    for o in context.scene.objects:
        if o != context.object:
            if o.type == 'MESH':
                arrObjs.append((o.name, o.name, ""))
    return arrObjs