import bpy
from bpy.types import Operator, PropertyGroup
from bpy.props import FloatVectorProperty, IntProperty, PointerProperty, FloatProperty, EnumProperty
from bpy_extras.object_utils import AddObjectHelper, object_data_add
from mathutils import Vector as V, Matrix
import math
from . tools import *


def on_enum_change(self, context):
    objs = self.objs
    if (objs != 'None'):
        vals = objBBox(objs)
    return None


def icoId(name):
    return pcoll[name].icon_id


def addTorus2_button(self, context):
    global pcoll
    self.layout.operator(OBJECT_OT_addTorus2.bl_idname,
                         text="Torus from 2 measures", icon_value=icoId('MESH_TOR'))


profileOpts = {
    'circle': ("Diameter", "", 1),
    'cuad': ("Side", "", 0),
    'rectangle': ("Width", "Height", 0),
    'rombus': ("Width", "Height", 0),
    'scoop': ("", "", 1),
}


class tor2props(PropertyGroup):
    typeItems = (
        ('circle', "Circle", "Circle", icoId('TOR_CIRC'), 0),
        ('cuad', "Square", "Square", icoId('TOR_SQ'), 1),
        ('rectangle', "Rectangle", "Rectangle", icoId('TOR_RECT'), 2),
        ('rombus', "Rombus", "Rombus", icoId('TOR_ROM'), 3),)
    sX: FloatProperty(name="Size X",  min=0.0, default=1)  # type: ignore
    sY: FloatProperty(name="Size Y", min=0.0, default=2.5)  # type: ignore
    # rEff1: FloatProperty(name="Size",  min=0.0, default=0.5)  # type: ignore
    type1: EnumProperty(
        name="Shape", description="Choose the type of edge", items=typeItems)  # type: ignore
    vertices: IntProperty(name="Vertices", description="Vertices",
                          default=12, min=2, max=150)  # type: ignore
    objs: EnumProperty(name="Object", items=list_objs,
                       update=on_enum_change)  # type: ignore
    w: FloatProperty(name="Width", min=0.01,  default=0.3)  # type: ignore
    h: FloatProperty(name="Height", min=0.01,  default=0.5)  # type: ignore
    verts: IntProperty(name="Verts", min=3,  default=12)  # type: ignore
    turns: IntProperty(name="turns", min=0,  default=0)  # type: ignore


def addTor2(self, context):
    sCt = self.cntrs2
    sX = sCt.sX
    sY = sCt.sY
    shape = sCt.type1
    w = sCt.w
    h = sCt.h
    turns = sCt.turns
    vertsn = sCt.verts
    vrts, edges, faces = tor2p(
        sX, sY, sCt.vertices, shape, w, h, vertsn, turns)
    meshname = 'cone2'
    mesh = bpy.data.meshes.new(name=meshname)
    self.meshname = mesh.name
    mesh.from_pydata(vrts, edges, faces)
    mesh.shade_smooth()
    mesh.update(calc_edges=True)
    mesh.validate(verbose=False)
    obj = object_data_add(context, mesh, operator=self)
    bpy.ops.object.shade_auto_smooth(angle=math.radians(40))
    # rotateTo(obj, V1)


def rotateTo(obj, v1, v2):
    v1 = V(v1)
    v2 = V(v2)
    direction = (v2 - v1).normalized()
    rot_matrix = direction.to_track_quat('Y', 'Z').to_matrix().to_4x4()
    loc_matrix = Matrix.Translation(v1)
    obj.matrix_world = loc_matrix @ rot_matrix
    return obj


def vectH(lay, var, varName, label=""):
    if label != "":
        lay.label(text=label)
    row = lay.row(align=True)
    row.prop(var, varName, index=0, text="x")
    row.prop(var, varName, index=1, text="y")
    row.prop(var, varName, index=2, text="z")
    return row


class OBJECT_OT_addTorus2(Operator, AddObjectHelper):
    """Create a new Mesh Object"""
    import os
    bl_idname = 'mesh.add_tor_2'
    bl_label = "Torus from 2 sizes"
    bl_icon = os.path.join(os.path.dirname(__file__), 'icons', 'mesh_tor')
    bl_options = {'REGISTER', 'UNDO'}
    cntrs2: PointerProperty(
        type=tor2props, name='cntrs2', description="Centers of the cylinder/cone")  # type: ignore

    @classmethod
    def poll(cls, context):
        return True

    def draw(self, context):
        lay = self.layout
        sCt = self.cntrs2
        col = lay.column()
        row = col.row()
        # row.label(text='Size X:')
        row.prop(sCt, 'sX', text='Size X:')
        row.prop(sCt, 'sY', text='Size Y:')
        col = lay.column()
        row = col.row()
        row.prop(sCt, 'type1', text="Profile:")
        row = col.row()
        currType = sCt.type1
        currProf = profileOpts[currType]
        row.prop(sCt, 'w', text=currProf[0])
        if (currProf[1] != ""):
            row.prop(sCt, 'h', text=currProf[1])
        if (currProf[2] == 1):
            row.prop(sCt, 'verts', text='Verts:')
        row = lay.row()
        lay.prop(sCt, 'vertices')
        lay.prop(sCt, 'turns')
        #lay.label(text='Centers from object bounding box corners')
        #lay.prop(sCt, 'objs')

    def execute(self, context):
        self.location = (0.0, 0.0, 0.0)
        addTor2(self, context)
        return {'FINISHED'}


def addTorus2_button(self, context):
    global pcoll
    self.layout.operator(OBJECT_OT_addTorus2.bl_idname,
                         text="Cylinder/cone from centers", icon_value=pcoll['MESH_CYL'].icon_id)


def ang2pRad(A, B, C):
    AB = B-A
    AC = C-A
    lnABC = AB.length * AC.length or 1
    return math.acos(AB.dot(AC)/lnABC)


def ang2p(A, B, C):
    return math.degrees(ang2pRad(A, B, C))


def rotV(vv, rot, axis='Z', translate=None):
    matriz_rotacion_z = Matrix.Rotation(math.radians(rot), 3, axis)
    rv = matriz_rotacion_z @ vv
    if translate:
        rv += translate
    return rv


def polis4(nums, faces, offs, close=0):
    if close == 0:
        for i in range(nums-1):
            faces.append([offs + i, offs + i+1, offs +
                          i + 1 + nums, offs + i + nums])
        faces.append([offs, offs+nums, offs + nums*2-1,  offs + nums-1])
    else:
        for i in range(nums-1):
            faces.append([offs + i, offs + i+1, i + 1, i])
        faces.append([offs+nums-1, offs, 0,  nums-1])


def addVrts(incRot, vertices, v1, translate, vrts, prof, full=0, turns=0):
    ang = 180/vertices
    if full != 0:
        ang = 360/vertices
    lprof = len(prof)
    turn = 0
    for n in range(vertices+1):
        rot = incRot + ang * n
        for i in range(lprof):
            p = prof[i]
            if turns > 0:
                p = rotV(p, turn, 'X')

            nn = rotV(p + v1, rot, 'Z', translate)
            vrts.append(nn)
        turn += turns
        print(str(turn))


def tor2p(sX, sY, nVrts, shape, w, h, vertsn, turns=1):
    vrts = []
    edges = []
    faces = []
    cX = sX/2
    cY = sY/2
    w = w/2
    h = h/2
    prof = (V((0, 0, -.1)), V((0, .1, 0)), V((0, 0, .1)), V((0, -.1, 0)))
    if shape == "cuad":
        prof = (V((0, w, -w)), V((0, w, w)), V((0, -w, w)), V((0, -w, -w)))
    if shape == "rectangle":
        prof = (V((0, w, -h)), V((0, w, h)), V((0, -w, h)),     V((0, -w, -h)))
    if shape == "rombus":
        prof = (V((0, w, 0)), V((0, 0, w)),  V((0, -w, 0)), V((0, 0, -w)))
    if shape == "circle":
        prof = []
        rot = 360/vertsn
        for n in range(vertsn):
            prof.append(rotV(V((0, w, 0)), rot*n, 'X'))
    if turns > 0:
        turns = (360*turns)/nVrts
    if cX == cY:
        addVrts(0, nVrts, V((0, -cY, 0)), V((0, 0, 0)), vrts, prof, 1, turns)
    else:
        if cX > cY:
            dif = (cX-cY)
            addVrts(0, nVrts, V((0, -cY, 0)),
                    V((dif, 0, 0)), vrts, prof, 0, turns)
            addVrts(180, nVrts, V((0, -cY, 0)),
                    V((-dif, 0, 0)), vrts, prof, 0, turns)
        else:
            dif = (cY-cX)
            addVrts(90, nVrts, V((0, -cX, 0)),
                    V((0, dif, 0)), vrts, prof, 0, turns)
            addVrts(270, nVrts, V((0, -cX, 0)),
                    V((0, -dif, 0)), vrts, prof, 0, turns)
    lP = len(prof)
    for y in range(int(len(vrts)/lP)):
        polis4(lP, faces, y*lP)
    polis4(lP, faces, len(vrts)-lP, 1)

    return vrts, edges, faces

# 410
